﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<MicroBlogThread>>" %>
<%int applicationID = ApplicationIDs.Instance().MicroBlog(); %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-microblog-list">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-border-gray tn-border-bottom">
                <strong>
                    <%=GetResourceString("Title_Talking",applicationID) %><%=GetResourceString("Common_Colon")%></strong>
            </div>
        </div>
        <div class="spb-status-box" id="listbox">
            <div class="spb-status-bottom-cover">
            </div>
            <ul id="newst" class="tn-list">
                <%if (Model != null)
                  {
                      int i, j;
                      i = 0;
                      j = Model.Count > 7 ? Model.Count - 7 : 0;
                      foreach (MicroBlogThread item in Model)
                      {%>
                <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom" <%if (i < j) Response.Write("style=\"display: none\""); %>>
                    <div class="tn-list-item-area-left">
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
                    </div>
                    <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row tn-list-item-summary">
                            <p class="tn-helper-reset">
                                <a name="author" class="tn-user-name" href="#">
                                    <%=item.Author%>：</a><%=item.LinkBody%></p>
                            <%if (item.HasPhoto || item.HasVideo || item.HasMusic)
                              {%>
                            <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=item.ThreadID %>">
                                <%if (item.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(item.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
                                <%if (item.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(item.ThreadID, item.ThumbnailUrl, item.PlayUrl, false)); %>
                                <%if (item.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(item.ThreadID, item.PlayUrl, false)); %>
                            </div>
                            <%} %>
                        </div>
                        <div class="tn-list-item-row tn-helper-align-right tn-helper-clearfix">
                            <em class="tn-date tn-text-note tn-helper-left">
                                <%=Formatter.FormatFriendlyDate(item.DateCreated,true)%></em></div>
                    </div>
                </li>
                <%i++;
                      }
                  }%>
            </ul>
        </div>
    </div>
</div>

<script type="text/javascript">

    $(document).ready(function() {
        $('ul#newst a').attr("href", "<%=SiteUrls.Instance().LoginInModal() %>");
        $('ul#newst a').dialog({
            id: 'loginDialog',
            title: '登录',
            width: 400
        });
        if ($("#newst li:hidden:last").length > 0) {
            var scrtime;
            $("#listbox").hover(function() {
                clearInterval(scrtime);
            }, function() {
                scrtime = setInterval(function() {
                    var $ul = $("#listbox ul");
                    var liHeight = $ul.find("li:hidden:last").height();
                    $ul.animate({ marginTop: liHeight + 15 + "px" }, 1000, function() {
                        $ul.css({ marginTop: 0 });
                        if ($.browser.msie && $.browser.version == '6.0') {
                            $ul.find("li:hidden:last").show().end().prepend($ul.find('li:last').hide());
                        }
                        else {
                            $ul.find("li:hidden:last").fadeIn(1000).end().prepend($ul.find('li:last').hide());
                        }
                    });
                }, 3000);
            }).trigger("mouseleave");
        }

    });
</script>

