﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<MicroBlogTopic>>" %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-hot-topics">
    <%int applicationID = ApplicationIDs.Instance().MicroBlog(); %>
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_HotTopic",applicationID) %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <%if (Model != null && Model.Count > 0)
          { %>
        <ul class="tn-helper-reset tn-list">
            <%
                foreach (MicroBlogTopic topic in Model)
                {
                    if (topic == null) continue;
            %>
            <li>
                <a href="<%=SPBUrlHelper.Action("ShowMicroBlogTopic", "MicroBlog", new RouteValueDictionary { {"topicID", topic.TopicID}})%>" title="<%=topic.Title %>">
                    <%=StringUtils.Trim(topic.Title, 15)%></a><em class="tn-count tn-text-note"> (<%=topic.ItemCount%>)</em>
            </li>
            <%} %>
        </ul>
        <p class="tn-more">
            <a href="<%=SPBUrlHelper.Action("MicroBlogsTopicRanks","MicroBlog")%>">
                <%=GetResourceString("Action_More")%></a></p>
        <%}
          else
          { %>
        <p class="tn-text-note">
            还没有人发表过任何话题。</p>
        <%} %>
    </div>
</div>
<div class="tn-blank10">
</div>
