﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<MicroBlogUserData>>" %>
<div class="spb-rank">
    <ol class="tn-helper-reset tn-list tn-list-rank tn-img-sprite">
        <% if (Model != null)
           {

               UserDataSortBy sortBy = (UserDataSortBy)ViewData["sortBy"];
               foreach (MicroBlogUserData userData in Model)
               {
                   if (userData == null) continue;               
               %>
        <li><em class="tn-count tn-text-note tn-helper-right">
            <%
                switch (sortBy)
                {
                    case UserDataSortBy.ThreadCount:
                        Response.Write(userData.ThreadCount);
                        break;
                    case UserDataSortBy.StageFollowerCount:
                        Response.Write(userData.StageFollowerCount);
                        break;
                    case UserDataSortBy.FollowerCount:
                        Response.Write(userData.FollowerCount);
                        break;
                    default:
                        break;
                }
                   %>
        </em>
            <a target="_blank" href="<%=SiteUrls.Instance().UserMicroBlogHome(userData.UserID)%>">
                <%=SPBHtmlHelper.Instance().UserDisplayName(userData.UserID) %></a>
        </li>
        <%}
           } %>
    </ol>
</div>
