﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<MicroBlogThread>>" %>
<%int screenID = Request.QueryString.GetInt("screenID", 0);%>
<%if (Model != null)
  {
      foreach (var thread in Model)
      {%>
<li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom <%if (MicroBlogThreads.IsInPalys(screenID, thread.ThreadID)) Response.Write("tn-bg-light"); %>"
    id="m_Item_<%=thread.ThreadID %>">
    <div class="tn-list-checkbox">
        <input type="checkbox" name="MicroBlog" class="tn-checkbox" value="<%=thread.ThreadID %>" />
    </div>
    <div class="tn-list-item-area-left">
        <div class="tn-avatar">
            <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
    </div>
    <div class="tn-list-item-area-right">
        <ul class="tn-list-actions">
            <li class="tn-list-action tn-bg-light tn-border-light tn-corner-all">
                <a title="插入播放列表" class="tn-icon tn-icon-arrow-rt" href="javascript:;" onclick="InsertPlays(<%=thread.ThreadID %>)">
                    插入播放列表</a></li>
            <li class="tn-list-action tn-bg-light tn-border-light tn-corner-all">
                <a title="加入播放列表" class="tn-icon tn-icon-send" onclick="AddPlay(<%=thread.ThreadID %>)">
                    加入播放列表</a></li>
        </ul>
    </div>
    <div class="tn-list-item-area-main">
        <div class="tn-list-item-row tn-list-item-summary">
            <p>
                <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>" title="<%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID) %>"
                    class="tn-user-name">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(thread.UserID,true) %>：</a><%=thread.LinkBody %></p>
            <%if (thread.HasPhoto)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix">
                <%Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
            </div>
            <%} %>
        </div>
        <%MicroBlogThread originalThread = thread.GetOriginalThread;
          if (thread.OriginalThreadID > 0 && originalThread != null)
          { %>
        <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
            <p>
                <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(originalThread.UserID) %>">
                    <%=originalThread.Author%>：</a><%=originalThread.LinkBody%></p>
            <%if (originalThread.HasPhoto || originalThread.HasVideo || originalThread.HasMusic)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                <% Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, thread.OriginalThreadID, MicroBlogPhotoTypes.Preview)); %>
            </div>
            <%} %>
            <div class="tn-list-item-row">
                <em class="tn-date">
                    <a href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">
                        <%=Formatter.FormatFriendlyDate(originalThread.DateCreated) %></a></em><span class="tn-pipe tn-text-note">|</span><span
                            class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">原文转发<%if (originalThread.ForwardedCount > 0) Response.Write("(" + originalThread.ForwardedCount + ")"); %></a>
                        </span>
                <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                    href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">原文评论<%if (originalThread.ReplyCount > 0) Response.Write("(" + originalThread.ReplyCount + ")"); %></a>
                </span>
            </div>
        </div>
        <%} %>
    </div>
    <div class="tn-list-item-row tn-helper-clearfix tn-helper-clear">
        <span class="tn-actions">
            <span class="tn-action">
                <a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID, thread.ThreadID)%>"
                    class="tn-action-text">
                    <%if (thread.ForwardedCount > 0) Response.Write("转发(" + thread.ForwardedCount + ")"); else Response.Write("转发"); %>
                </a>
            </span>
            <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID, thread.ThreadID)%>"
                class="tn-action-text"><%if (thread.ReplyCount > 0) Response.Write("评论（" + thread.ReplyCount + "）"); else Response.Write("评论"); %></a>
            </span>
        </span>
        <span class="spb-fav-operate">
            <a title="存入收藏夹1" href="javascript:;" class="tn-corner-o tn-bg-light tn-border-deep"
                onclick="FavoriteM(1,<%=thread.ThreadID %>)">1</a><a title="存入收藏夹2" href="javascript:;"
                    onclick="FavoriteM(2,<%=thread.ThreadID %>)" class="tn-corner-o tn-bg-light tn-border-deep">2</a><a
                        title="存入收藏夹3" href="javascript:;" onclick="FavoriteM(3,<%=thread.ThreadID %>)"
                        class="tn-corner-o tn-bg-light tn-border-deep">3</a></span><em class="tn-date tn-text-note"><a
                            href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID, thread.ThreadID)%>">
                            <%=Formatter.FormatFriendlyDate(thread.DateCreated,true) %></a></em></div>
</li>
<%}
  }%>
