﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<SiteTag>>" %>
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
  int pageCount = Model.TotalRecords / Model.PageSize;
  int mod = Model.TotalRecords % Model.PageSize;
  if (mod > 0 && mod < Model.PageSize)
      pageCount = pageCount + 1;

  if (pageCount == pageIndex || Model.TotalRecords < Model.PageSize)
      pageIndex = 1;
  else
      pageIndex = pageIndex + 1;%>
<div class="spb-has-tags">
    <div class="tn-text-heading">
        <%if (pageCount > 0)
          {%>
        <a href="javascript:;" onclick="loadToUserSiteTags()" class="tn-helper-right">换一换</a>
        <%} %>
        <strong>你可能感兴趣的标签</strong></div>
    <div id="UserSiteTagsDiv">
        <ul class="spb-tags">
            <%if (ViewData.Model != null && ViewData.Model.Records != null)
              {
                  foreach (var siteTag in ViewData.Model.Records)
                  {%>
            <li class="spb-tag">
                <a class="tn-invert-text" href="javascript:;" title="添加标签">
                    <%=StringUtils.Trim(siteTag.TagName,10)%><span class="tn-icon tn-icon-add tn-icon-inline"></span></a></li>
            <%}
              }%>
        </ul>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('li a', $('#UserSiteTagsDiv')).click(function() {
            if ($('#MySTagsDiv').find('li').length >= 10) {
                $.dialog.alert('最多只能添加10个标签！');
            }
            else {
                $('#MTagsDiv').load('<%=SPBUrlHelper.Action("CreateUserTag", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }})%>?tageName=' + encodeURIComponent($(this).text().replace('\n', "")));
                $(this).parent().hide();
            }
        });
    });

    function loadToUserSiteTags() {
        $('#UserSiteTagsDiv').parent().parent().load('<%=SPBUrlHelper.Action("Control_UserSiteTags","MicroBlog",new RouteValueDictionary{{ "userDomainName", userDomainName } ,{"pageIndex",pageIndex}}) %>');
    }

</script>

