﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<PersonUser>" %>

<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%>
</asp:content>
<asp:content id="LRContentRegion" runat="server" contentplaceholderid="LRContentRegion">
</asp:content>
<asp:content id="WideContentRegion" runat="server" contentplaceholderid="WideContentRegion">
<div class="spb-seting">
    <div class="tn-tabs tn-widget">
        <ul class="tn-tabs-nav tn-helper-clearfix">
            <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected">
                <a href="<%=SPBUrlHelper.Action("BasicInfoSetting", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                    <span>个人资料</span></a></li>
            <li class="tn-widget-content tn-border-gray tn-border-trl">
                <a href="<%=SPBUrlHelper.Action("UploadAvatar", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                    <span>修改头像</span></a></li>
        </ul>
        <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
            <div class="tn-directory">
                <div class="tn-directory-level">
                    <span class="tn-directory-item tn-selected"><strong class="tn-text-note">基本信息</strong>
                    </span>
                    <span class="tn-directory-item">
                        <a href="<%=SPBUrlHelper.Action("BussinessSetting", "MicroBlog", new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } })%>">
                            职业信息</a>
                    </span>
                    <span class="tn-directory-item ">
                        <a href="<%=SPBUrlHelper.Action("UserTags", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                            个人标签</a>
                    </span>
                </div>
            </div>
            <%
                string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
                int applicationID = ApplicationIDs.Instance().User();%>
            <% PersonUser user = ViewData.Model; %>
            <%Dictionary<string, PrivacyItemSettings> privacyItemSettingss = ViewData["PrivacyItemSettingss"] as Dictionary<string, PrivacyItemSettings>;%>
            <% if (TempData["StatusMessageType"] != null)
               {
                   StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                   if (messageType == StatusMessageType.Success)
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                   else
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
               }
               TempData["StatusMessageType"] = null;
               SiteSettings setting = null;
               if (ViewData["SiteSetting"] != null)
                   setting = ViewData["SiteSetting"] as SiteSettings;
            %>
            <form id="EditProfileForm" method="post" action="<%=SPBUrlHelper.Action("UpdateSettingBasicInfo","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
            <div class="tn-form tn-label-right">
                <input type="hidden" id="type" name="type" value="<%=(int)PersonProfileType.BasicInfo %>" />
                <% if (SiteSettingsManager.GetSiteSettings().EnableNickName)
                   { %>
                <div class="tn-form-row tn-nickname">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_ShowUserNickName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                    <div class="tn-input-multiple">
                        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="nickName"
                            name="nickName" value="<%=Formatter.FormatSingleLinePlainTextForEdit(user.NickName) %>" />
                    </div>
                </div>
                <%} %>
                <div class="tn-form-row tn-name">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon") %>
                    </label>
                    <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="commonName"
                        name="commonName" value="<%=Formatter.FormatSingleLinePlainTextForEdit(user.CommonName) %>" />
                </div>
                <div class="tn-form-row tn-gender">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_PersonUserGender",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                    <div class="tn-input-multiple">
                        <input type="radio" class="tn-radiobutton" id="maleItem" name="gender" <%if(user.Gender == Genders.Male) Response.Write("checked=\"checked\"");  %>
                            value="1" />
                        <label for="maleItem">
                            <%=GetResourceString("Enum_Genders_Male")%></label>
                        <input type="radio" class="tn-radiobutton" id="femaleItem" name="gender" <%if(user.Gender == Genders.Female) Response.Write("checked=\"checked\"");  %>
                            value="2" />
                        <label for="femaleItem">
                            <%=GetResourceString("Enum_Genders_Female") %></label>
                    </div>
                </div>
                <div class="tn-form-row tn-birth">
                  <label class="tn-form-label"><%=GetResourceString("Label_PersonUserBirthday", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                  <% DateTime? defaultdate = null;
                     if (user.Birthday > DateTime.MinValue)
                         defaultdate = user.Birthday;
                     Html.RenderAction<ChannelController>(n => n.Control_Datepicker("birthday", 1919, DateTime.Now.Year, defaultdate, false, "tn-textbox tn-input-medium tn-border-gray")); %>
                </div>
                <div class="tn-form-row tn-location">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_UserAreaCode",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                    <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("nowAreaCode", UserDomainConfiguration.Instance().RootAreaCode, user.NowAreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
                    <span class="tn-text-note">
                        <%=GetResourceString("Description_UserAreaCode",applicationID)%></span>
                </div>
                <div class="tn-form-row tn-school">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_PersonUserSchool",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                    <input type="text" class="tn-textbox tn-input-long tn-border-gray" maxlength="100"
                        id="school" name="school" value="<%=user.School %>" readonly="readonly">
                    <%=SPBHtmlHelper.Instance().Button("selectSchool","选择学校",ButtonSizes.Default,HighlightStyles.Secondary,null,null)%>
                    <div class="tn-text-note">
                        <%=GetResourceString("Description_PersonUserSchool",applicationID)%></div>
                    <input type="hidden" id="schoolID" name="schoolID" value="<%=user.SchoolID %>" />
                </div>
                <div class="tn-form-row tn-im">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_PersonUserMSN",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                    <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="msnIM" name="msnIM"
                        value="<%=user.MsnIM %>" />
                </div>
                <div class="tn-form-row tn-im">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_PersonUserQQ",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                    <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="qqIM" name="qqIM"
                        value="<%=user.QQIM %>" maxlength="100" />
                </div>
                <div class="tn-form-row tn-introduction">
                    <label class="tn-form-label">
                        <%=GetResourceString("Label_PersonUserSelfAppraisal",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                    <textarea class="tn-textarea tn-input-longest tn-border-gray" rows="2" cols="100"
                        name="selfAppraisal" id="selfAppraisal"><%=Formatter.FormatMultiLinePlainTextForEdit(user.SelfAppraisal,true)%></textarea>
                    <div class="tn-text-note">
                        <%=GetResourceString("Description_PersonUserSelfAppraisal",applicationID)%></div>
                </div>
                <div class="tn-form-row tn-form-row-button">
                    <label class="tn-form-label">
                    </label>
                    <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_UpdateUserBaseInfo", applicationID), ButtonSizes.Default, null, null)%>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>
<script type="text/javascript">
      $(document).ready(function() {
          $("#EditProfileForm").validate({
              rules: {
                  commonName: { maxBlength: 30 },
                  nickName: { maxBlength: 30 },
                  birthday: { dateISO: true },
                  selfAppraisal: { maxBlength: 200 },
                  interest: { maxBlength: 200 },
                  expertise: { maxBlength: 200 },
                  msnIM: { maxBlength: 100 },
                  qqIM: { digits:true,maxlength:20}
              },
              messages: {
                  commonName: { maxBlength: '<%=GetResourceString("Validate_CommonNameMaxlength", applicationID) %>' },
                  nickName: { maxBlength: '<%=GetResourceString("Validate_NickNameMaxLength", applicationID)%>' },
                  birthday: { dateISO: '<%=GetResourceString("Validate_BirthdayDateISO", applicationID)%>' },
                  selfAppraisal: { maxBlength: "最多输入200个字！" },
                  interest: { maxBlength: "最多输入200个字！" },
                  expertise: { maxBlength: "最多输入200个字！" },
                  msnIM: { maxBlength: "最多输入100个字符！" },
                  qqIM: { digits: "必须输入数字！", maxlength: "最大长度为20位！" }
              }
          });
          $('#selectSchool').click(function(e) {
              e.preventDefault();
              $.nyroModalManual({
                  modal: false,
                  width: 700,
                  height: 400,
                  url: '<%=SPBUrlHelper.Action("Control_SchoolSelector","Channel",new RouteValueDictionary{{"textBoxID","school"},{"hiddenID","schoolID"}}) %>'
              });
              return false;
          });
          $("#postButton").click(function() {
              if (!$("#EditProfileForm").valid()) {
                  return false;
              }
          });
      });
</script>
</asp:content>
