﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<PersonUser>" %>

<asp:content contentplaceholderid="HeaderContent" runat="server">  
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%> 

</asp:content>
<asp:content runat="server" contentplaceholderid="WideContentRegion"> 

<div class="spb-seting">
                <div class="tn-tabs tn-widget">
                    <ul class="tn-tabs-nav tn-helper-clearfix">
                        <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected">
                            <a href="<%=SPBUrlHelper.Action("BasicInfoSetting", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                                <span>个人资料</span></a></li>
                        <li class="tn-widget-content tn-border-gray tn-border-trl">
                            <a href="<%=SPBUrlHelper.Action("UploadAvatar", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                                <span>修改头像</span></a></li>
                    </ul>
                    <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
                        <div class="tn-directory">
                            <div class="tn-directory-level">
                                <span class="tn-directory-item ">
                                    <a href="<%=SPBUrlHelper.Action("BasicInfoSetting", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                                        基本信息</a>
                                </span>
                                 <span class="tn-directory-item tn-selected"><strong class="tn-text-note">职业信息</strong>
                                </span>
                                
                                <span class="tn-directory-item ">
                                <a href="<%=SPBUrlHelper.Action("UserTags", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                                个人标签</a>                               
                                </span>
                            </div>
                        </div>
                  
                   
  <%
      string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
      int applicationID = ApplicationIDs.Instance().User();%>
  <% PersonUser user = Model; %>
  <%Dictionary<string, PrivacyItemSettings> privacyItemSettingss = ViewData["PrivacyItemSettingss"] as Dictionary<string, PrivacyItemSettings>;%>   

      
            <% if (TempData["StatusMessageType"] != null)
               {
                   StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                   if (messageType == StatusMessageType.Success)
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
                   else
                       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
               }
               TempData["StatusMessageType"] = null;
               SiteSettings setting = null;
               if (ViewData["SiteSetting"] != null)
                   setting = ViewData["SiteSetting"] as SiteSettings;
               %>          
              <form id="EditProfileForm" method="post" action="<%=SPBUrlHelper.Action("UpdateSettingBussiness","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
         <div class="tn-form tn-label-right">
         <input type="hidden" id="type" name="type" value="<%=(int)PersonProfileType.BusinessContact%>" />
        
                <div class="tn-form-row tn-company">
             <label class="tn-form-label"><%=GetResourceString("Label_PersonUserCompanyName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
             <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="Text1" name="companyName" value="<%=user.CompanyName %>" />        
            </div>
            
          
           <div class="tn-form-row tn-job">
              <label class="tn-form-label"><%=GetResourceString("Label_PersonUserJob",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="title" name="title"   value= "<%=user.Title %>"/> 
            </div>

            
            <div class="tn-form-row tn-categories">
             <label class="tn-form-label"><%=GetResourceString("Label_PersonUserJobSort",applicationID)%><%=GetResourceString("Common_Colon") %></label>
             <%=SPBHtmlHelper.Instance().ShowJobSortsDropDownList("jobSort", new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.JobSort)%>
            </div>
        
           
               <div class="tn-form-row tn-industry">
             <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserTrade",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <% Dictionary<int, CodeItem> Trades = CodeItems.GetCodeItems(CodeSetCodes.Instance().Trade()); %>    
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("companyTrade", Trades.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.CompanyTrade)%>        
            </div>
            
            <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"></label>
              <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_UpdatePersonUserBusinessInfo", applicationID), ButtonSizes.Default, null, null)%>
          </div>
         
         </div>
      </form>
        </div>
                </div>
            </div>
   
  <script type="text/javascript">
      $(document).ready(function() {
          $("#EditProfileForm").validate({
              rules: {
                  title: { maxBlength: 50 },
                  companyName: { maxBlength: 100 }

              },
              messages: {
                  title:{ mexlength:"最多50个字符！"},
                  companyName:{ mexlength:"最多100个字符！"}

              }
          });

          $("#postButton").click(function() {
              if (!$("#EditProfileForm").valid()) {
                  return false;
              }
          });
      });
  </script>


</asp:content>
