﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<SearchResultDataSet<MicroBlogThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="MicroBlogPageListMicroBlogsOfTopic"
</asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%> 
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<%int applicationID = ApplicationIDs.Instance().MicroBlog();
  string keyword = TempData.GetString("Keyword", string.Empty);%>
 
 <div class="spb-search-box">
    <div class="tn-form tn-form-single tn-bg-gray tn-border-gray tn-helper-clearfix">
        <form id="mb_search" method="get" action="<%=SPBUrlHelper.Action("SearchMicroBlogs","MicroBlog") %>">
        <input type="text" name="keyword" id="searchKeyword" class="tn-textbox tn-border-gray"
            value="<%=keyword %>" maxlength="40" />
        <input type="hidden" id="favkeyword" value="<%=keyword %>" />
        <input type="hidden" name="type" />
        <%=SPBHtmlHelper.Instance().SubmitButton("serachmbt", "搜索",ButtonSizes.Large,null,null) %>
        </form>
        <% %>
        <ul class="tn-actions" style="display: none">
            <li>
                <span class="tn-action tn-action-text-icon">
                    <a class="tn-action-text" name="Favorite" href="javascript:;">
                        <%if (!MicroBlogTopics.IsFavorite(CurrentUser != null ? CurrentUser.UserID : 0, keyword))
                          { %><span class="tn-icon tn-icon-star"></span>关注话题<%}
                          else { Response.Write("取消关注"); }%></a>
                </span>
            </li>
            <%--<li>
                <span class="tn-action tn-action-text-icon">
                    <span class="tn-icon tn-icon-microblog"></span>
                    <a class="tn-action-text" href="javascript:;">来说两句</a>
                </span>
            </li>--%>
        </ul>
    </div>
</div>
<div class="tn-tabs tn-widget spb-microblog-list spb-search-results">
    <ul class="tn-tabs-nav tn-helper-clearfix">
        <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected">
            <a href="javascript:;">
                <span>微博</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl">
            <a id="searchUser" value="<%=(int)MicroBlogSearchType.User %>" href="<%=SPBUrlHelper.Action("SearchUsers", "MicroBlog", new RouteValueDictionary { {"type",(int)MicroBlogSearchType.User}})%>">
                <span>用户</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
        <%if (Model != null && Model.Records.Count > 0)
          { %>
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-border-gray tn-border-bottom">
                <%=GetResourceString("Title_About", applicationID)%>
                <strong>“<%=keyword %>”</strong>
                <%=GetResourceString("Title_The", applicationID)%><%=GetResourceString("Action_MicroBlog", applicationID)%>
                <strong>
                    <%=Model != null ? Model.TotalRecords : 0 %></strong>
                <%=GetResourceString("Title_Article", applicationID)%>
            </div>
        </div>
        <ul class="tn-list">
            <%foreach (var thread in Model.Records)
              { %>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-area-left">
                    <div class="tn-avatar">
                        <a href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
                </div>
                <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-summary">
                        <p>
                            <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(thread.UserID) %>">
                                <%=thread.Author%>：</a><%=thread.LinkBody%></p>
                        <%if (thread.HasPhoto || thread.HasVideo || thread.HasMusic)
                          {%>
                        <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                            <%if (thread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
                            <%if (thread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(thread.ThreadID, thread.ThumbnailUrl, thread.PlayUrl, false)); %>
                            <%if (thread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(thread.ThreadID, thread.PlayUrl, false)); %>
                        </div>
                        <%} %>
                    </div>
                    <%MicroBlogThread originalThread = thread.GetOriginalThread;
                      if (thread.OriginalThreadID > 0 && originalThread != null)
                      { %>
                    <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
                        <p>
                            <a class="tn-user-name" href="<%=SiteUrls.Instance().UserMicroBlogHome(originalThread.UserID) %>">
                                <%=originalThread.Author%>：</a><%=originalThread.LinkBody%></p>
                        <%if (originalThread.HasPhoto || originalThread.HasVideo || originalThread.HasMusic)
                          {%>
                        <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=thread.ThreadID %>">
                            <%if (originalThread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(thread.ThreadID, thread.OriginalThreadID, MicroBlogPhotoTypes.Preview)); %>
                            <%if (originalThread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(thread.ThreadID, originalThread.ThumbnailUrl, originalThread.PlayUrl, false)); %>
                            <%if (originalThread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(thread.ThreadID, originalThread.PlayUrl, false)); %>
                        </div>
                        <%} %>
                        <div class="tn-list-item-row">
                            <em class="tn-date">
                                <a href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">
                                    <%=Formatter.FormatFriendlyDate(originalThread.DateCreated,true)%></a></em><span class="tn-pipe tn-text-note">|</span><span
                                        class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalForward", applicationID)%></a>
                                    </span>
                            <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                                href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalComment", applicationID)%></a>
                            </span>
                        </div>
                    </div>
                    <%} %>
                    <div class="tn-list-item-row tn-helper-align-right tn-helper-clearfix">
                        <em class="tn-date tn-text-note tn-helper-left">
                            <a href="<%=SiteUrls.Instance().ShowMicroBlog(thread.UserID,thread.ThreadID) %>">
                                <%=Formatter.FormatDate( thread.DateCreated,true)%></a></em>
                        <span class="tn-action">
                            <%if (CurrentUser != null)
                              { %>
                            <a href="<%=SPBUrlHelper.Action("Control_ForwardMicroBlog","MicroBlog",new RouteValueDictionary {{"threadID",thread.ThreadID}}) %>"
                                class="tn-action-text" name="forwardmb">
                                <%=GetResourceString("Action_Forward",applicationID)%></a><%}
                              else
                              { %>
                            <em class="tn-text-note">
                                <%=GetResourceString("Action_Forward", applicationID)%></em>
                            <%} %>
                        </span>
                        <span class="tn-pipe tn-text-note">|</span>
                        <%if (CurrentUser != null && CurrentUser.UserID != thread.UserID)
                          { %>
                        <span class="tn-action">
                            <%if (!MicroBlogThreads.IsFavorite(CurrentUser.UserID, thread.ThreadID))
                              { %>
                            <a name="fAction" href="javascript:;" tid='<%=thread.ThreadID %>' status='0'>收藏</a>
                            <%}
                              else
                              { %>
                            <a name="fAction" href="javascript:;" tid='<%=thread.ThreadID %>' status='1'>取消收藏</a>
                            <%} %></span>
                        <span class="tn-pipe tn-text-note">|</span>
                        <%} %>
                        <span class="tn-action">
                            <a name="reply" href="javascript:;" value="<%=thread.ThreadID %>" class="tn-action-text">
                                <%=GetResourceString("Action_Comment", applicationID)%></a></span>
                    </div>
                    <%if (CurrentUser != null)
                      { %>
                    <div class="tn-simple-comments" id="ListComments_<%=thread.ThreadID %>" style="display: none">
                        <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                            <div class="tn-bubble-box-arrow">
                                <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
                                <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
                                <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
                                <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
                                <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
                            </div>
                            <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all" id="microBlogReplyContainer_<%=thread.ThreadID %>"
                                value="<%=SPBUrlHelper.Action("Control_ListCommentsOfThread","MicroBlog",new RouteValueDictionary{{"threadID",thread.ThreadID}}) %>">
                                <div class="tn-loading">
                                </div>
                            </div>
                        </div>
                    </div>
                    <%} %>
                </div>
            </li>
            <%} %>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)%>
        </div>
        <%}
          else
          { %>
        <div class="tn-list-header">
            <%  Html.RenderPartial("Controls/NoSearchResult.ascx");%>
        </div>
        <%} %>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        if ($('#favkeyword').val().length > 0 && $('#favkeyword').val().length <= 40) {
            $('ul.tn-actions').show();

            $("a[name=Favorite]").click(function() {
                $.get('<%=SPBUrlHelper.Action("FaviteTopic","MicroBlog") %>', { keyword: encodeURIComponent($('#favkeyword').val()) },
                function(data) {
                    if (data.ok) {
                        if (data.isFavorite == 'create') {
                            $('a[name=Favorite]').text('取消关注');
                        } else {
                            $('a[name=Favorite]').text('').append('<span class="tn-icon tn-icon-star"></span>').find('span.tn-icon-star').after('关注话题');
                        }
                    }
                });
            });
        }
       <%if (CurrentUser != null)
        { %>
        $('a[name=reply]').click(function() {
            var $comments = $('#microBlogReplyContainer_' + $(this).attr("value"));
            if ($("#ListComments_" + $(this).attr("value")).is(":hidden")) {
                if ($comments.find("div.tn-loading").length) {
                    $('#microBlogReplyContainer_' + $(this).attr("value")).load($('#microBlogReplyContainer_' + $(this).attr("value")).attr("value"));
                } 
		$("#ListComments_" + $(this).attr("value")).show();
                $(this).text('<%=GetResourceString("Message_HideComments",applicationID) %>');
            }
            else {
                $("#ListComments_" + $(this).attr("value")).hide();
                $(this).text('<%=GetResourceString("Action_Comment", applicationID)%>');
            }
        });
        
        $("a[name='fAction']").click(function(){
              var $favorite = $(this);
              if ($(this).attr("status") <= 0) {
                  $.get('<%=SPBUrlHelper.Action("FavoriteMicroBlog", "MicroBlog")%>', {threadID: $favorite.attr('tid') }, function(data) {
                      $favorite.html('取消收藏').attr("status", 1);
                  });
              }
              else {
                  $.get('<%=SPBUrlHelper.Action("FavoriteMicroBlog", "MicroBlog")%>', { threadID: $favorite.attr('tid') }, function(data) {
                       $favorite.html('收藏').attr("status", 0);
                  });
              }
        });

        //video_start
        $('div[name=videoThumb]').click(function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#play_video_' + tid).length > 0) {
                if($.browser.msie)
                    $('#play_video_' + tid).show().find('div.spb-video-play').html('<embed height="416" width="450" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="'+ $(this).attr("playurl") +'"></embed>');
                else
                    $('#play_video_' + tid).show().find('embed').attr("src", $(this).attr("playurl"));
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_video_" + tid + "\">&nbsp;</div>").hide();
                $('#play_video_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogVideo","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
        });
        
        $("span[name=stop_Video]").live("click", function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        $('a[type=Video]', $("ul.tn-list")).click(function() {
            var $thumblist = $(this).parent().siblings('div[id*=thumb_list]');
            var tid = $thumblist.attr("id").replace(/[^0-9]/ig, "");
            if($.browser.msie)
              $('#play_music_' + tid).hide().find('object').remove();
            else
              $('#play_music_' + tid).hide().find('embed').attr("src", "");
              
            $('#view_photo_' + tid).hide();
            if ($('#play_video_' + tid).length > 0) {
                $thumblist.hide();
                
            if($.browser.msie)
                $('#play_video_' + tid).show().find('div.spb-video-play').html('<embed height="416" width="450" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="'+ $(this).attr("playurl") +'"></embed>');
            else
                $('#play_video_' + tid).show().find('embed').attr("src", $(this).attr("playurl"));
                
            }
            else {
                $thumblist.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_video_" + tid + "\">&nbsp;</div>").hide();
                $('#play_video_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogVideo","MicroBlog") %>?play=true&threadID=' + tid + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
            return false;
        });
        //video_end

        //music_start
        var playurl = '<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?autoPlay=false&audioUrl=';
        $('div[name=musicThumb]').click(function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#play_music_' + tid).length > 0) {
                if($.browser.msie)
                   $('#play_music_' + tid).show().find('div.spb-music-play').html('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwav/cabs/flash/swflash.cab#version=6,0,40,0">'
                    + '<param name="bgcolor" value="#ffffff" />'
                    + '<param name="flashvars" value="playerMode=embedded" />'
                    + '<param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl='+ $(this).attr("playurl") +'&autoPlay=true" />'
                    + '<param name="wmode" value="window" />'
                    + '<param name="quality" value="best" />'
                    + '<embed type="application/x-shockwave-flash" width="400" height="27" src="'+ $(this).attr("playurl") +'" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed></object>');               
                else
                   $('#play_music_' + tid).show().find('embed').attr("src", playurl + $(this).attr("playurl"));
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_music_" + tid + "\">&nbsp;</div>").hide();
                $('#play_music_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogMusic","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
        });
        $("span[name=stop_Music]").live("click", function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        $('a[type=Music]', $("ul.tn-list")).click(function() {
            var $thumblist = $(this).parent().siblings('div[id*=thumb_list]');
            var tid = $thumblist.attr("id").replace(/[^0-9]/ig, "");
            $('#view_photo_' + tid).hide();
            if($.browser.msie)                    
              $('#play_video_' + tid).hide().find('embed').remove();
            else
              $('#play_video_' + tid).hide().find('embed').attr("src", "");
              
            if ($('#play_music_' + tid).length > 0) {
                
                $thumblist.hide();
                if($.browser.msie)
                   $('#play_music_' + tid).show().find('div.spb-music-play').html('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwav/cabs/flash/swflash.cab#version=6,0,40,0">'
                    + '<param name="bgcolor" value="#ffffff" />'
                    + '<param name="flashvars" value="playerMode=embedded" />'
                    + '<param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl='+ $(this).attr("playurl") +'&autoPlay=true" />'
                    + '<param name="wmode" value="window" />'
                    + '<param name="quality" value="best" />'
                    + '<embed type="application/x-shockwave-flash" width="400" height="27" src="'+ $(this).attr("playurl") +'" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed></object>');               
                else
                   $('#play_music_' + tid).show().find('embed').attr("src", playurl + $(this).attr("playurl"));
            }
            else {
                $thumblist.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_music_" + tid + "\">&nbsp;</div>").hide();
                $('#play_music_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogMusic","MicroBlog") %>?play=true&threadID=' + tid + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
            return false;
        });
        //music_end

        //photo_start
        $('div[name=previewPhoto]').click(function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#view_photo_' + tid).length > 0) {
                $('#view_photo_' + tid).show();
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"view_photo_" + tid + "\">&nbsp;</div>").hide();
                $('#view_photo_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogPhoto","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + '&othreadID='+ $(this).attr('otid') + "&type=" + '<%=MicroBlogPhotoTypes.View %>');
            }
        });
        $("div[name=viewPhoto]").live("click", function() {
            var tid = $(this).attr('tid');
            if($.browser.msie)                    
            {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else
            {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        //photo_end
        
        $('a[name=forwardmb]').dialog({
         id: 'showForwardmb',
         title: '<%=GetResourceString("Title_ForwardToMy", applicationID)%>',
         width: 300             
        });
        
        <%}
        else 
        {%>
        $('ul.tn-list a').attr("href","<%=SiteUrls.Instance().LoginInModal() %>");
        $('ul.tn-list a').dialog({
            id: 'loginDialog',
            title: '登录',
            width: 400             
        });
        <%} %>
        $('#searchUser,#searchUserTag').click(function() {
            var $s_form = $('#mb_search');
            if ($s_form.find("input[type=text]").val().length > 0) {
                $s_form.attr("action", $(this).attr('href'));
                $s_form.find("input[name=type]").val($(this).attr('value'));
                $s_form.submit();
                return false;
            }
        });
    });
</script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
    <%Html.RenderAction<MicroBlogController>(n => n.Control_TopMicroBlogTopic(10)); %>
</asp:content>
