﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<PagingDataSet<InstationNoticeRecord>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="ListNoticeRecords"
</asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%> 
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<div id="ListNoticeRecordsDiv" class="spb-notice">
<div class="tn-pagename">
  <strong class="tn-text-heading">我的通知</strong>
  </div>
  <div  class="tn-box tn-widget tn-widget-content tn-corner-all spb-talk">
  <div class="tn-box-content tn-widget-content tn-corner-all">
   <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName"); %>
   
        <form id="ListNoticeRecordsForm" method="post">
       
 <div class="tn-list-header">
<div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
<em class="tn-text-note tn-count">  <%=string.Format(GetResourceString("Label_NoticeRecordInfo",ApplicationIDs.Instance().User()), ViewData.Model.TotalRecords ) %>
</em>
<span class="tn-action tn-action-text-icon">
<span class="tn-icon tn-icon-set"></span>
   <a class="tn-action-text" target="_blank" href="<%=SPBUrlHelper.Action("NoticeSettings","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>" >通知设置</a>
</span>
 </div>
 </div>  
      <ul class="tn-list">
            <%foreach (InstationNoticeRecord record in ViewData.Model.Records)
              { %>
              <li class="tn-list-item tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                
            </div>
            <div class="tn-list-item-area-right">

            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row">
                    <cite>
                         <%=record.Subject %></cite><em class="tn-text-note tn-date">  <%=Formatter.FormatFriendlyDate(record.DateCreated)%></em></div>
                <div class="tn-list-item-row tn-list-item-summary">
                    <p class="tn-helper-reset" title="<%=HtmlUtils.StripAllTags(record.Body) %>">
                    <%=HtmlUtils.TrimHtml(record.Body, 40) %></p>
                    <div class="tn-list-item-row">
                       
                    </div>
                </div>
            </div>
        </li>
            
            
            
            
            <%} %>
        </ul>
     
          <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListNoticeRecords", "MessageCenter", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
            <div class="tn-page-results tn-text-note">
                <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
        </div>
     
    </form> 
     
     
      <script type="text/javascript">
          function pageIndexChange(url) {
              $('#ListNoticeRecordsDiv').parent().load(url);
          }
    </script>
    </div>
    </div>
   </div> 
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
    <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");%>     
    <%Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogInfo(userDomainName, -1)); %>
    <%Html.RenderAction<MicroBlogController>(n => n.Control_TopMicroBlogTopic(10)); %>
    <%Html.RenderAction<MicroBlogController>(n => n.Control_RecommendUsersBlock(11005, 9)); %>

</asp:content>
