﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainPublicViewPage<PagingDataSet<MicroBlogThread>>" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="MicroBlogHeader" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="artDialog" Src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
        SetExpireDays="30" />
</spb:Header>
<body id="spb-login-page" class="tn-page-bg">
    <div id="tn-doc" class="tn-doc-bg">
        <div class="tn-header-bg" id="tn-header">
            <div class="tn-wrapper tn-helper-clearfix">
                <div class="spb-top-menubar">
                    <div class="tn-wrapper-inner tn-helper-clearfix">
                        <div class="spb-home-link">
                            <a href="<%=SiteUrls.Instance().Home() %>" class="spb-top-logo-link">返回总站</a>
                        </div>
                    </div>
                </div>
                <div class="spb-branding-area">
                    <div class="tn-wrapper-inner">
                        <div id="spb-logo">
                            <a href="<%=SPBUrlHelper.Action("MicroBlogRanks", "MicroBlog")%>"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="tn-content" class="tn-content-bg">
            <div class="tn-wrapper tn-template-r-230 tn-helper-clearfix">
                <div class="tn-main">
                    <div class="tn-block">
                        <div class="spb-hot-topics-box" id="TopTopicInLogin">
                            <div class="tn-box tn-widget tn-corner-all">
                                <div class="tn-box-content tn-widget-content tn-corner-all">
                                    <div class="tn-helper-clearfix">
                                        <div class="spb-left-cover">
                                        </div>
                                        <div class="spb-right-cover">
                                        </div>
                                        <strong>
                                            <%=GetResourceString("Title_Hot",ApplicationIDs.Instance().MicroBlog())%><%=GetResourceString("Common_Colon")%></strong>
                                        <ul>
                                            <%IList<MicroBlogTopic> topices = ViewData["Topices"] as IList<MicroBlogTopic>;
                                              if (topices != null)
                                              {
                                                  foreach (MicroBlogTopic topic in topices)
                                                  {%>
                                            <li>
                                                <a href="JavaScript:;">
                                                    <%=topic.Body %></a></li>
                                            <%}
                                              }%>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tn-blank10">
                        </div>
                        <%Html.RenderAction<MicroBlogController>(n => n.Control_TopMicroBlogThreads()); %>
                    </div>
                </div>
                <div class="tn-block">
                    <% if (TempData["StatusMessageType"] != null)
                       {
                           StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
                           TempData["StatusMessageType"] = null;
                       }
                       bool enableSina = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppSecret"]);
                       bool enableQQ = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppSecret"]);%>
                    <div class="spb-login-panel" id="MicroBlogLogin">
                        <%if (SiteSettingsManager.GetSiteSettings().RegistrationMode == RegistrationModes.EnableAll)
                          { %>
                        <div class="spb-reg-btn-box">
                            <a class="spb-reg-btn" href="<%=SPBUrlHelper.Action("Register","ChannelUser")%>">立即注册微博</a>
                        </div>
                        <%} %>
                        <form id="loginForm" action="<%=SPBUrlHelper.Action("LoginInSampleAction", "MicroBlog")%>"
                        method="post">
                        <div class="tn-form tn-label-right">
                            <div class="tn-form-row tn-helper-clearfix">
                                <label class="tn-form-label">
                                    <%=GetResourceString("Title_Account", ApplicationIDs.Instance().MicroBlog())%><%=GetResourceString("Common_Colon")%></label>
                                <input type="text" id="LoginUserName" name="LoginUserName" class="tn-textbox tn-border-gray" />
                            </div>
                            <div class="tn-form-row tn-helper-clearfix">
                                <label class="tn-form-label">
                                    <%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon")%></label>
                                <input type="password" id="LoginPassword" name="LoginPassword" class="tn-textbox tn-border-gray" />
                            </div>
                            <div class="tn-form-row tn-form-row-button">
                                <%=SPBHtmlHelper.Instance().SubmitButton("","登录")%>
                                <a href="<%=SPBUrlHelper.Action("ForgotPassword","ChannelUser")%>">忘记密码？</a></div>
                            <%if (enableQQ || enableSina)
                              { %>
                            <div class="spb-third-id-login tn-border-gray tn-border-top">
                                <strong>使用第三方账号登录</strong>
                                <p class="tn-helper-clearfix">
                                    <%if (enableSina)
                                      { %>
                                    <a href="javascript:;" onclick="openSina();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-sina">
                                        使用新浪微博账号登录</a>
                                    <%} if (enableQQ)
                                      { %>
                                    <a href="javascript:;" onclick="openQQ();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-qq">
                                        使用QQ号登录</a>
                                    <%} %></p>
                            </div>
                            <%} %>
                        </div>
                        </form>

                        <script type="text/javascript">
                            $(document).ready(function() {
                                $("#loginForm").validate({
                                    rules: {
                                        LoginUserName: "required",
                                        LoginPassword: "required"
                                    },
                                    messages: {
                                        LoginUserName: "用户名不能为空",
                                        LoginPassword: "密码不能为空"
                                    },
                                    showErrors: $.dialog.showErrors,
                                    onfocusout: false,
                                    onclick: false,
                                    onkeyup: false,
                                    onsubmit: true
                                });
                                //$('ul a', $('#TopTopicInLogin')).attr("href", "<%=SiteUrls.Instance().LoginInModal() %>");
                                //$('ul a', $('#TopTopicInLogin')).dialog({
                                //    id: 'loginDialog',
                                //    title: '登录',
                                //    width: 400
                                //});
                                $("#loginForm").submit(function() {
                                    if (!$("#loginForm").valid()) {
                                        return false;
                                    }
                                });
                            });
                            function openQQ() {
                                var A = window.open("<%=SiteUrls.Instance().LoginToQQ() %>", "TencentLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
                            }
                            function openSina() {
                                var B = window.open("<%=SiteUrls.Instance().LoginToSina() %>", "SinaLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
                            }
                        </script>

                    </div>
                    <%Html.RenderAction<MicroBlogController>(n => n.Control_RecommendUsersBlock(11005, 9)); %>
                </div>
            </div>
        </div>
        <div class="tn-footer-bg" id="tn-footer">
            <div class="tn-wrapper">
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
    </div>
</body>
</html>
