﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<PersonUser>" %>

<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%>
</asp:content>
<asp:content id="WideContentRegion" runat="server" contentplaceholderid="WideContentRegion">
<spb:Script runat="server" ID="mouse" Src="~/Utility/jquery/ui.mouse.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script ID="Script1" runat="server" Src="~/Utility/jquery/ui.draggable.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script ID="Script2" runat="server" Src="~/Utility/jquery/ui.sortable.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="metadata" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="tagIt" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
<%string userTagItemKey = UserTagItemKeys.Instance().Person();

  List<string> selectedUserTags = ViewData.Get<List<string>>("SelectedUserTags");
  ICollection<UserTag> myTags = UserTagManager.Instance(userTagItemKey).GetUserTags(CurrentUser.UserID, true);

  string getTagsJosnUrl = SPBUrlHelper.Action("GetSuggestTagsJosn", "Channel", new RouteValueDictionary { { "userTagItemKey", userTagItemKey } });

  string selectedUserTagValue = "{}";
  System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
  if (selectedUserTags != null && selectedUserTags.Count > 0)
  {
      selectedUserTagValue = serializer.Serialize(selectedUserTags.Select(n => new { value = n }));
  }

  int pageIndex = Html.GetParameterFromRouteDateOrQueryString("pageIndex", 1);
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  int applicationID = ApplicationIDs.Instance().User();%>
<div class="tn-content-bg" id="tn-content">
    <div class="tn-wrapper">
        <div class="tn-grid">
            <div class="spb-seting">
                <div class="tn-tabs tn-widget">
                    <ul class="tn-tabs-nav tn-helper-clearfix">
                        <li class="tn-widget-content tn-border-gray tn-border-trl tn-tabs-selected">
                            <a href="<%=SPBUrlHelper.Action("BasicInfoSetting", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                                <span>个人资料</span></a></li>
                        <li class="tn-widget-content tn-border-gray tn-border-trl">
                            <a href="<%=SPBUrlHelper.Action("UploadAvatar", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                                <span>修改头像</span></a></li>
                    </ul>
                    <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
                        <div class="tn-directory">
                            <div class="tn-directory-level">
                                <span class="tn-directory-item">
                                    <a href="<%=SPBUrlHelper.Action("BasicInfoSetting", "MicroBlog",new RouteValueDictionary { {"userDomainName",CurrentUser.UserName}})%>">
                                        基本信息</a>
                                </span>
                                <span class="tn-directory-item">
                                    <a href="<%=SPBUrlHelper.Action("BussinessSetting", "MicroBlog", new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } })%>">
                                        职业信息</a>
                                </span>
                                <span class="tn-directory-item tn-selected"><strong class="tn-text-note">个人标签</strong>
                                </span>
                            </div>
                        </div>
                        <div class="tn-widget">
                            <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
                                <div class="tn-helper-flowfix">
                                    添加你自己感兴趣的标签，找到与你有共同爱好的人。</div>
                            </div>
                        </div>
                        <div class="spb-set-tags tn-border-gray tn-helper-clearfix">
                            <div class="spb-set-my-tags tn-border-gray tn-border-right">
                                <div class="tn-text-heading">
                                    <strong>我的标签</strong></div>
                                <div id="MTagsDiv">
                                    <% Html.RenderAction("Control_ListMyUserSiteTags", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName } }); %>
                                </div>
                                <div class="tn-expand-control">
                                    <div class="tn-form tn-form-single">
                                        <form id="CreateUserTagForm" action="<%=SPBUrlHelper.Action("CreateUserTag", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName } }) %>"
                                        method="post">
                                        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userTags"
                                            name="userTags" />
                                        <span class="tn-button tn-button-primary">
                                            <span class="tn-first-child">
                                                <button type="submit" class="tn-button-text">添加</button>
                                            </span>
                                        </span>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <% Html.RenderAction("Control_UserSiteTags", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "pageIndex", Request.QueryString.GetInt("pageIndex", 1) } }); %>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- InstanceEndEditable -->
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $.ajaxSetup({ cache: false });
        $("#userTags").autoSuggest("<%=getTagsJosnUrl %>", 
        {
        asHtmlID:"userTags",
        minChars: 1,
        keyDelay: 600,
        selectionLimit:5,
        preFill: <%=selectedUserTagValue %>,
        enableManualAdd: true
        });
        
        $('#CreateUserTagForm').ajaxForm({ target: '#MTagsDiv',success:function(){
                $('#as-selections-userTags li.as-selection-item').remove();
                $('#userTags').val('');        
            }
        });
        
    });
</script>

</asp:content>
