﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<PagingDataSet<MicroBlogThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="MicroBlog-MicroBlogRanks" </asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
  <%Html.RenderPartial("Controls/Header.ascx", ViewData);%>
</asp:content>
<asp:content contentplaceholderid="WideContentRegion" runat="server">
  <%int applicationID = ApplicationIDs.Instance().MicroBlog();
  int sortBy = ViewData.GetInt("SortBy", (int)MicroBlogThreadSortBy.DateCreated);
  ViewData["BrowseSubMenu"] = (int)MicroBlogBrowseSubMenu.News;
  Html.RenderPartial("Controls/MicroBlogBrowseSubMenu.ascx", ViewData);%>
  <div class="tn-grid spb-browse">
    <div class="tn-unit tn-first">
      <div class="tn-tabs tn-widget spb-microblog-list spb-new-microblog">
        <ul class="tn-tabs-nav tn-helper-clearfix">
          <li class="tn-widget-content tn-border-gray tn-border-trl <%if (sortBy == (int)MicroBlogThreadSortBy.DateCreated) Response.Write("tn-tabs-selected"); %>"> <a href="<%=SPBUrlHelper.Action("MicroBlogRanks", "MicroBlog", new RouteValueDictionary { { "sortBy", (int)MicroBlogThreadSortBy.DateCreated} })%>"> <span> 最新微博</span></a></li>
          <li class="tn-widget-content tn-border-gray tn-border-trl <%if (sortBy == (int)MicroBlogThreadSortBy.ForwardedCount) Response.Write("tn-tabs-selected"); %>"> <a href="<%=SPBUrlHelper.Action("MicroBlogRanks", "MicroBlog", new RouteValueDictionary { { "sortBy", (int)MicroBlogThreadSortBy.ForwardedCount} })%>"> <span> 热门转发</span></a></li>
          <li class="tn-widget-content tn-border-gray tn-border-trl <%if (sortBy == (int)MicroBlogThreadSortBy.ReplayCount) Response.Write("tn-tabs-selected"); %>"> <a href="<%=SPBUrlHelper.Action("MicroBlogRanks", "MicroBlog", new RouteValueDictionary { { "sortBy", (int)MicroBlogThreadSortBy.ReplayCount} })%>"> <span> 热门评论</span></a></li>
        </ul>
        <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top" id="MicroBlogRanks_<%=sortBy.ToString() %>">
          <div>
            <%Html.RenderAction<MicroBlogController>(n => n.Control_ListNewMicroBlogs((MicroBlogThreadSortBy)sortBy, Request.QueryString.GetInt("pageIndex", 1))); %>
          </div>
        </div>
      </div>
    </div>
    <div class="tn-unit">
      <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");%>
      <%Html.RenderAction<MicroBlogController>(n => n.Control_TopMicroBlogTopic(10)); %>
    </div>
  </div>
</asp:content>
<asp:content contentplaceholderid="LRContentRegion" runat="server"> </asp:content>
