﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<PagingDataSet<MicroBlogScreen>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="MicroBlogMyScreens"
</asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx");%> 
</asp:content>
<asp:content contentplaceholderid="WideContentRegion" runat="server">
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  string actionurl = "javascript:;";
  if (CurrentUser != null && CurrentUser.Rank >= MicroBlogConfiguration.Instance().CreateScreenRank)
      actionurl = SPBUrlHelper.Action("Control_EditScreen", "MicroBlog", new RouteValueDictionary { { "userDomainName", userDomainName } });
    
    %>

<div class="tn-grid">
        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-my-screen">
          <div class="tn-box-content tn-widget-content tn-corner-all">
            <div class="tn-list-header"><%=SPBHtmlHelper.Instance().LinkButton("CreateScreen", "申请大屏幕",actionurl , ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
              <h4>我的大屏幕</h4>
            </div>
            <table class="tn-table-grid">
              <tbody><tr class="tn-table-grid-header">
                <th class="tn-border-gray tn-border-bottom tn-text-note">名称</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">访问地址</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">开始时间</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">截止时间</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">审核情况</th>
                <th class="tn-border-gray tn-border-bottom tn-text-note">操作</th>
              </tr>
              <%
                  if (Model != null)
                  {
                      foreach (var screen in Model.Records)
                      { %>                                          
              <tr class="tn-table-grid-row">                         
                <td class="tn-border-gray tn-border-bottom">
                <%if (screen.IsFilter)
                  { %>
                <a target="_blank" href="<%=SPBUrlHelper.Action("ScreenLeadStudio", "MicroBlog", new RouteValueDictionary {{"screenID",screen.ScreenID}})%>"><%=screen.ScreenName%></a>
                <%}
                  else
                  { Response.Write(screen.ScreenName); } %>
                </td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><a target="_blank" href="<%=SPBUrlHelper.Action("Screen", "MicroBlog", new RouteValueDictionary { {"screenID",screen.ScreenID}})%>"><%=WebUtils.FullPath(SPBUrlHelper.Action("Screen", "MicroBlog", new RouteValueDictionary { { "screenID", screen.ScreenID } }))%></a></td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=screen.IsDeadline? screen.StartDate.ToString():string.Empty %></td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=screen.IsDeadline ? screen.EndDate.ToString() : string.Empty %></td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><%if (screen.AuditingStatus == AuditingStatuses.Success) Response.Write("已通过审核"); else Response.Write("未通过审核");%></td>
                <td class="tn-border-gray tn-border-bottom tn-nowrap"><a onclick ="if(!confirm('确认要删除当前大屏幕？')) return false;" href="<%=SPBUrlHelper.Action("DeleteScreen", "MicroBlog", new RouteValueDictionary { {"userDomainName",userDomainName },{"screenID",screen.ScreenID},{"pageIndex",Html.GetParameterFromRouteDateOrQueryString<int>("pageIndex")}}) %>">删除</a></td>
              </tr>
              <%}
                  }%>
            </tbody></table>
            <%if (Model != null)
              { %>
            <div class="tn-pagination tn-helper-align-center">
                <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords, Model.PageSize, Model.PageIndex, 7,null)%>
            </div>
            <%} %>
          </div>
        </div>
      </div>
      <div id="errorMsg" style="display: none">
          <div class="spb-bind-tip">
              <p>等级达到<%=MicroBlogConfiguration.Instance().CreateScreenRank %>级才能创建大屏幕！</p>
          </div>
      </div>
      <script type="text/javascript">
          $(document).ready(function() {
              <%if(CurrentUser!=null && (CurrentUser.Rank >= MicroBlogConfiguration.Instance().CreateScreenRank||CurrentUser.IsAdministrator||CurrentUser.IsContentAdministrator)) {%>
              $('#CreateScreen').dialog({
                  id: 'EditScreenBox',
                  title: '申请大屏幕'
              });
              <%} 
              else{%>
              $('#CreateScreen').click(function(){
                  $.dialog({ id:'errorMsgDialog',content:$("#errorMsg").html(),width:300});
                  return false;
              });
              <%} %>
          });
      </script>
</asp:content>
<asp:content contentplaceholderid="LRContentRegion" runat="server">
</asp:content>
