﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage" %>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="NewMessage"
</asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%> 
</asp:content>
<asp:content id="mainContent" runat="server" contentplaceholderid="mainContent">
<spb:Script runat="server" ID="mouse" Src="~/Utility/jquery/ui.mouse.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script ID="Script1" runat="server" Src="~/Utility/jquery/ui.draggable.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script ID="Script2" runat="server" Src="~/Utility/jquery/ui.sortable.min-1.8.12.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="metadata" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="tagIt" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
<div class="spb-message">
    <div class="tn-pagename tn-helper-clearfix">
        <strong class="tn-text-heading">写私信</strong><span class="tn-action"><a href="<%=SPBUrlHelper.Action("ListMessageInBox","MicroBlog",new RouteValueDictionary { { "userDomainName", CurrentUser.UserName } }) %>"
            class="tn-action-text">返回收件箱</a>
        </span>
    </div>
    <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
    <%bool isAllowed = ViewData.GetBool("IsAllowed", false);
      bool isMultiple = ViewData.GetBool("IsMultiple", false);
      if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          if (messageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
          Response.Write("<br/>");
          TempData["StatusMessageType"] = null;
      }
      User toUser = ViewData.Get<User>("ToUser", null);
      System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
      string selectedUsersValue = "{}";
      if (toUser != null)
      {
          selectedUsersValue = serializer.Serialize(new List<object>{new
          {
              userID = toUser.UserID,
              displayName = toUser.DisplayName,
              commonName = toUser.CommonName,
              nickName = toUser.NickName,
              noteName = ""
          
          }});
      }
      string getUsersJosnUrl = SPBUrlHelper.Action("SearchUsers", "Channel");%>
    <div class="tn-form tn-label-top spb-write">
        <form id="newMessageForm" name="newMessageForm" class="tn-helper-reset" action="<%=SPBUrlHelper.Action("CreateMessage","MicroBlog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"
        method="post">
        <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
            <label class="tn-form-label">
                选择好友：</label>
            <div class="tn-expand-control">
                <%string userID = string.Empty;
                  if (isAllowed && !isMultiple && toUser != null)
                      userID = toUser.UserID.ToString();%>
                <%if (ViewData.GetBool("sendToServe", false))
                  { %>
                <input type="text" readonly="readonly" name="" value="客服" class="tn-textbox tn-input-long tn-border-gray"
                    disabled="disabled" />
                <input type="hidden" name="receiverIDs" value="<%=(int)PrivateMessageEspecialUserID.Serve %>" />
                <%}
                  else
                  { %>
                <input type="text" id="receiverIDs" name="receiverIDs" value="" class="tn-textbox tn-input-long tn-border-gray" />
                <%--<% Html.RenderAction<ChannelController>(n => n.Control_FriendSelector("receiverIDs", userID, 10)); %>--%>
                <%--<div class="tn-text-note"><%=GetResourceString("Message_NewMessageMaxReceiverNum", ApplicationIDs.Instance().User())%></div> --%>
                <%} %>
            </div>
        </div>
        <div class="tn-form-row tn-emotion-box">
            <label class="tn-form-label">
                <%=GetResourceString("Label_Subject",ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" id="subject" name="subject" class="tn-textbox tn-input-longest tn-border-gray"
                value="<%=TempData.GetString("subject", string.Empty)%>" maxlength="128" />
            <div class="tn-blank10">
            </div>
            <label class="tn-form-label">
                <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %>
            </label>
            <div class="tn-emotion-textarea tn-textarea-wrap">
                <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("smiley", "body"));%>
                <textarea class="tn-textarea tn-input-longest tn-border-gray" rows="5" cols="60"
                    name="body" id="body"></textarea>
                    <span style="display:none"></span>
            </div>
            <div class="tn-text-note tn-helper-clear">
                <%=GetResourceString("Message_NewMessageMaxBobyHint",ApplicationIDs.Instance().User())%>
            </div>
        </div>
        <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label">
            </label>
            <%=SPBHtmlHelper.Instance().SubmitButton("sendButton", GetResourceString("Button_Send"))%>
            <% if (Request.UrlReferrer != null)
               {%>
            <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri) %>
            <%} %>
        </div>
        </form>
    </div>
</div>
<script type="text/javascript">
        $(document).ready(function() {
            $("#newMessageForm").validate({
                rules: {
                    subject: { required: true, rangelength: [1, 30] },
                    body: { required: true }
                },
                messages: {
                    subject: { required: "<%=GetResourceString("Validate_NewMessageSubjectEmpty",ApplicationIDs.Instance().User()) %>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_NewMessageSubjectMaxLength",ApplicationIDs.Instance().User()),30) %>" },
                    body: { required: "fgdfsdf" }
                }
            });

            $("#receiverIDs").autoSuggest("<%=getUsersJosnUrl %>", 
            {
            asHtmlID:"receiverIDs",
            minChars:1,
            keyDelay:600,
            selectionLimit:10,
            selectedItemProp:"displayName",
            selectedValuesProp:"userID",
            searchObjProps:"displayName,commonName,nickName,noteName",
            enableManualAdd:true,
            preFill:<%=selectedUsersValue %>,
            formatList: function(data, elem) {
                var new_elem = elem.html("<a href=\"javascript:;\"><img src=\"" + data.userAvatarUrl + "\" width=\"22px\">" + data.displayName + "</a>");
                    return new_elem;
                }

            });

            $('#getReceivers').nyroModal({
                resizeable: true,
                endShowContent: function(elts, settings) {
                    $('#submitButton', elts.contentWrapper).click(function(e) {
                        e.preventDefault();
                        var receiverDispalyNames = new Array();
                        var receiverIDs = new Array();
                        $('input[checked][name="userSelectorCheckBox"]', elts.contentWrapper).each(function(i) {
                            var result = eval('(' + $(this).val() + ')');
                            receiverIDs[i] = result.userid;
                            receiverDispalyNames[i] = result.displayname;
                        });
                        $("#receiverDispalyNames").attr("value", receiverDispalyNames.toString());
                        $("#receiverIDs").attr("value", receiverIDs.toString());
                        $.nyroModalRemove();
                    });
                }
            });
        });
</script>  
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");%>     
    <%Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogInfo(userDomainName, ViewData.GetInt("MicroBlogDomainSubMenu"))); %>
    <%Html.RenderAction<MicroBlogController>(n => n.Control_TopMicroBlogTopic(10)); %>
    <%Html.RenderAction<MicroBlogController>(n => n.Control_RecommendUsersBlock(11005, 9)); %>
</asp:content>
