﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<MicroBlogScreen>" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="position" Src="~/Utility/jquery/ui.position.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="artDialog" Src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="jqrotate" Src="~/Utility/jquery/plugin/jqrotate.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="scrollTo" Src="~/Utility/jquery/plugin/jquery.scrollTo-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
    <style type="text/css">
        #MrcroblogScreen *
        {
            cursor: default;
        }
        #MrcroblogScreen a
        {
            cursor: text;
        }
    </style>
</spb:Header>
<body id="MrcroblogScreen" class="spb-big-screen">
    <div id="tn-doc" class="tn-doc-bg">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper">
                <div class="spb-branding-area">
                    <div class="tn-wrapper-inner tn-helper-clearfix">
                        <div class="spb-logo">
                            <a></a>
                        </div>
                        <%if (Model != null)
                          {%>
                        <div class="spb-screen-text">
                            <h1>
                                <%=Model.ScreenName%></h1>
                            <p class="tn-description">
                                在微博中输入#<%=Model.Keyword%>#参与话题，或通过以下链接参与话题</p>
                            <p class="tn-url">
                                <a href="javascript:;">
                                    <%=SiteUrls.Instance().Topic(Model.Keyword,true) %></a>
                            </p>
                        </div>
                        <%} %>
                    </div>
                </div>
            </div>
        </div>
        <div id="tn-content" class="tn-content-bg">
            <%if (Model != null)
              { %>
            <div class="tn-grid">
                <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-microblog-list">
                    <div class="tn-box-content tn-widget-content tn-corner-all">
                        <div class="spb-screen-list">
                            <%--<div class="spb-top-cover">
                            </div>--%>
                            <div class="spb-bottom-cover">
                            </div>
                            <ul class="tn-list" id="palylist">
                            </ul>
                            <div>
                                <ul class="tn-list" id="waitLists">
                                </ul>
                                <input type="hidden" id="itemID" />
                                <input type="hidden" id="itemThreadID" />
                            </div>

                            <script type="text/javascript">
                                var loadtime;
                                $(document).ready(function() {
                                    loadData();

                                });

                                function scroll() {
                                    if ($('#waitLists li').length > 0) {
                                        var $pul = $('#palylist');
                                        var $palyitem = $("#waitLists li:first");
                                        var liHeight = $palyitem.height();
                                        $palyitem.css({ height: 0 });
                                        $pul.prepend($palyitem);
                                        $palyitem.animate({ height: liHeight + "px" }, 1000);
                                    }

                                }

                                function loadData() {
                                    try {
                                        $.get('<%=SPBUrlHelper.Action("ScreenItems", "MicroBlog", new RouteValueDictionary {{"screenID",Model.ScreenID}})%>', { itemID: $('#itemID').val(), threadID: $('#itemThreadID').val() }, function(data) {
                                            if (data) {
                                                $("#waitLists").append($(data));
                                                $("#waitLists p a").removeAttr('href');
                                                if ($('#waitLists li').length > 0) {
                                                    $('#itemID').val($('#waitLists li:first').find('input[name=item]').val());
                                                    $('#itemThreadID').val($('#waitLists li:first').find('input[name=threadItem]').val());
                                                }
                                                if ($(data).hasClass("item_0"))
                                                    $('#waitLists li:first').remove();
                                                else
                                                    scroll();
                                            }
                                            loadtime = setTimeout(function() { loadData() }, 6000);
                                        });
                                    }
                                    catch (err) {
                                        loadtime = setTimeout(function() { loadData() }, 6000);
                                    }
                                }

                                function Pause(obj) {
                                    if ($(obj).val() == 0) {
                                        clearTimeout(loadtime);
                                        $(obj).val(1).text('取消暂停');
                                    }
                                    else {
                                        loadData();
                                        $(obj).val(0).text('暂停');
                                    }
                                }

                            </script>

                        </div>
                        <div class="tn-toolbar-area">
                            <span class="tn-button tn-button-large tn-button-default">
                                <span class="tn-first-child">
                                    <button class="tn-button-text" id="pause" value="0" onclick="Pause(this);">
                                        暂停</button>
                                </span>
                            </span>
                            <%--<span class="tn-button tn-button-large tn-button-default">
                                <span class="tn-first-child">
                                    <button class="tn-button-text">
                                        上一条</button>
                                </span>
                            </span>
                            <span class="tn-button tn-button-large tn-button-default">
                                <span class="tn-first-child">
                                    <button class="tn-button-text">
                                        下一条</button>
                                </span>
                            </span>--%>
                        </div>
                    </div>
                </div>
            </div>
            <%} %>
        </div>
        <div class="tn-footer-bg" id="tn-footer">
            <div class="tn-wrapper">
                <div class="tn-footer-legal">
                    <p class="tn-text-note tn-secondary-text">
                        Powered by
                        <a href="http://www.spacebuilder.cn" target="_blank">Spacebuilder</a>
                        v3.2 ©2005-2011 Tunynet Inc.
                    </p>
                </div>
            </div>
        </div>
    </div>
    <div style="z-index: 1988;" id="aui_iframe_mask">
    </div>
    <div id="aui_overlay">
        <div>
            <!--[if IE 6]><iframe src="about:blank"></iframe><![endif]-->
        </div>
    </div>
    <div style="z-index: 1989;" id="aui_temp_wrap">
        <div id="aui_temp">
            <!--[if IE 6]><iframe src="about:blank"></iframe><![endif]-->
        </div>
    </div>
</body>
</html>
