﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<MicroBlogScreen>" %>

<asp:content contentplaceholderid="HeaderContent" runat="server">
<div class="spb-branding-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="spb-logo">
            <a></a>
        </div>
        <div class="spb-screen-text">
            <h2>
                导播室(<%if (Model != null) Response.Write(StringUtils.Trim(Model.ScreenName, 8)); %>)</h2>
                <%if (CurrentUser != null)
                  { %>
            <p class="spb-user-menu">
                <a href="<%=SiteUrls.Instance().UserMicroBlogHome(CurrentUser.UserID) %>" title="<%=CurrentUser.DisplayName %>"><%=CurrentUser.DisplayName %></a><a href="<%=SPBUrlHelper.Action("Logout","MicroBlog")%>">退出</a></p>
                <%} %>
        </div>
    </div>
</div>
</asp:content>
<asp:content contentplaceholderid="Contents" runat="server">
<%int serialNumber = Request.QueryString.Get("serialNumber", 1); %>
<div class="tn-grid">
    <div class="tn-widget">
        <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
            请在投影屏幕中，打开微博墙页面：<a target="_blank" href="<%=SPBUrlHelper.Action("Screen", "MicroBlog", new RouteValueDictionary { {"screenID",Model.ScreenID}})%>">
            <%=WebUtils.FullPath(SPBUrlHelper.Action("Screen", "MicroBlog", new RouteValueDictionary { { "screenID", Model.ScreenID } }))%></a>
        </div>
    </div>
</div>
<div class="tn-grid-3-13">
    <div class="tn-unit tn-first">
        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-screen-favorites">
            <div class="tn-box-content tn-widget-content tn-corner-all">
                <div class="tn-actions">
                    <span class="tn-button tn-button-large tn-button-primary">
                        <span class="tn-first-child">
                            <a class="tn-button-text" target="_blank" href="<%=SPBUrlHelper.Action("Screen", "MicroBlog", new RouteValueDictionary { {"screenID",Model.ScreenID}})%>">打开大屏幕</a>
                        </span>
                    </span>
                </div>
                <ul class="tn-border-gray tn-border-top">
                    <li <%if (serialNumber == 1) Response.Write("class=\"tn-selected tn-bg-light tn-border-light tn-corner-o\""); %>><em class="tn-corner-o tn-bg-light tn-border-light">1</em><a href="<%=SPBUrlHelper.Action("ScreenFavorites", "MicroBlog", new RouteValueDictionary { { "screenID", Model.ScreenID }, { "serialNumber",1 } })%>">收藏夹</a></li>
                    <li <%if (serialNumber == 2) Response.Write("class=\"tn-selected tn-bg-light tn-border-light tn-corner-o\""); %>><em class="tn-corner-o tn-bg-light tn-border-light">2</em><a href="<%=SPBUrlHelper.Action("ScreenFavorites", "MicroBlog", new RouteValueDictionary { { "screenID", Model.ScreenID }, { "serialNumber",2 } })%>">收藏夹</a></li>
                    <li <%if (serialNumber == 3) Response.Write("class=\"tn-selected tn-bg-light tn-border-light tn-corner-o\""); %>><em class="tn-corner-o tn-bg-light tn-border-light">3</em><a href="<%=SPBUrlHelper.Action("ScreenFavorites", "MicroBlog", new RouteValueDictionary { { "screenID", Model.ScreenID }, { "serialNumber",3 } })%>">收藏夹</a></li>
                </ul>
            </div>
        </div>
    </div>
    <div class="tn-unit">
    <% int? pageIndex = ViewData["pageIndex"] as int?; %>
        <div class="tn-tabs tn-widget">
            <%StatusMessageType messageType = StatusMessageType.Success;
              if (TempData["StatusMessageData"] != null)
              {
                  StatusMessageData messageData = (StatusMessageData)TempData["StatusMessageData"];
                  messageType = messageData.MessageType;
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
                  TempData["StatusMessageData"] = null;
              }
              if (Model != null && messageType == StatusMessageType.Success)
              {
                  Html.RenderAction<MicroBlogController>(n => n.Control_ListMicroBlogsOfScreenFavorite(Model.ScreenID, serialNumber, pageIndex));
              }%>
        </div>
    </div>
</div>

</asp:content>
