﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<SearchResultDataSet<PersonUser>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="MicroBlogPageSearchUsers"
</asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%> 
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<%int applicationID = ApplicationIDs.Instance().MicroBlog();
  int type = ViewData.GetInt("type", (int)MicroBlogSearchType.User); %>
<div class="spb-search-box">    
    <div class="tn-form tn-form-single tn-bg-gray tn-border-gray tn-helper-clearfix">
        <form method="get" id="mb_search" action="<%=SPBUrlHelper.Action("SearchUsers","MicroBlog") %>">
            <input type="text" name="keyword" id="searchKeyword" class="tn-textbox tn-border-gray" value="<%=TempData.GetString("Keyword",string.Empty) %>" />
            <%=SPBHtmlHelper.Instance().SubmitButton("serachmbt", "搜索",ButtonSizes.Large,null,null) %>
            <div class="tn-input-multiple">
              <input id="sUser" type="radio" name="type" value="<%=(int)MicroBlogSearchType.User %>" <%if (type == (int)MicroBlogSearchType.User) { Response.Write("checked=\"checked\""); } %> class="tn-radiobutton" />      
              <label for="sUser">用户名</label>
              <input id="sUserTag" type="radio" name="type" value="<%=(int)MicroBlogSearchType.UserTag %>" <%if (type == (int)MicroBlogSearchType.UserTag) { Response.Write("checked=\"checked\""); } %> class="tn-radiobutton" />
              <label for="sUserTag">标签</label>
            </div>
        </form>
    </div>
</div>
<div class="tn-tabs tn-widget spb-microblog-list spb-search-results">
    <ul class="tn-tabs-nav tn-helper-clearfix">
        <li class="tn-widget-content tn-border-gray tn-border-trl">
            <a id="searchMicroBlog" href="<%=SPBUrlHelper.Action("SearchMicroBlogs", "MicroBlog")%>"> 
                <span>微博</span></a></li>
        <li class="tn-widget-content tn-border-gray tn-border-trl <%if (type == (int)MicroBlogSearchType.User ||type== (int)MicroBlogSearchType.UserTag) Response.Write("tn-tabs-selected");%>">
            <a id="searchUser"  value="<%=(int)MicroBlogSearchType.User %>" href="<%=SPBUrlHelper.Action("SearchUsers", "MicroBlog", new RouteValueDictionary { {"type",(int)MicroBlogSearchType.User}})%>">
                <span>用户</span></a></li>
    </ul>
    <div class="tn-tabs-panel tn-widget-content tn-border-gray tn-border-top">
        <%if (Model != null && Model.Records.Count > 0)
          {%>
        <ul class="tn-list tn-helper-reset">
            <%foreach (PersonUser item in Model.Records)
              {
                  MicroBlogUserData userData = MicroBlogUserDatas.GetUserData(item.UserID, false);
                  if (userData != null)
                  {%>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-area-left">
                    <div class="tn-avatar">
                        <a href="<%=SiteUrls.Instance().MyMicroBlogs(item.UserID) %>">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(item.UserID, false, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></a></div>
                </div>
                <div class="tn-list-item-area-right">
                    <% if (CurrentUser != null && CurrentUser.UserID != item.UserID)
                       {
                           if (!MicroBlogFollows.IsFollow(CurrentUser.UserID, item.UserID))
                               Response.Write(SPBHtmlHelper.Instance().LinkButton(item.UserID.ToString(), GetResourceString("Action_Follow", applicationID), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "name", "follow" }, { "value", 1 } }, null));
                           else
                               Response.Write(SPBHtmlHelper.Instance().LinkButton(item.UserID.ToString(), GetResourceString("Action_CancelFollow", applicationID), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "name", "follow" }, { "value", 0 } }, null)); %>
                    <%} %>
                </div>
                <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                        <h5 class="tn-helper-reset">
                            <a href="<%=SiteUrls.Instance().MyMicroBlogs(item.UserID) %>">
                                <%=userData.GetUserIdentifier.DisplayName%></a></h5>
                    </div>
                    <div class="tn-list-item-row">
                       <em class="tn-count tn-text-note"><%=GetResourceString("Action_Follower", applicationID)%><%if (userData.FollowerCount > 0) Response.Write(userData.FollowerCount); else Response.Write("0");%><%=GetResourceString("Title_People", applicationID)%></em></div>
                    <div class="tn-list-item-row">
                           <%ICollection<UserTag> usertags = UserTagManager.Instance(UserTagItemKeys.Instance().Person()).GetUserTags(item.UserID, false);
                             if (usertags != null)
                             {
                                 foreach (var usertag in usertags)
                                 { %>
                             <a href="<%=SPBUrlHelper.Action("SearchUsers", "MicroBlog", new RouteValueDictionary { { "type", (int)MicroBlogSearchType.UserTag }, { "Keyword", WebUtils.UrlEncode(usertag.TagName) } })%>"><%=usertag.TagName %></a>
                            <%}
                             } %>   
                    </div>
                    <div class="tn-list-item-row tn-list-item-summary">
                        <p class="tn-helper-reset">
                            <a href="<%=SiteUrls.Instance().ShowMicroBlog(item.UserID,userData.MostRecentThreadID) %>">
                                <%=HtmlUtils.TrimHtml(userData.MostRecentThreadBody, userData.MostRecentThreadBody.Length)%></a></p>
                    </div>
                </div>
            </li>
            <%}
              }%>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)%>
        </div>
        <%}
          else
          { %>
            <div class="tn-list-header">
                <%Html.RenderPartial("Controls/NoSearchResult.ascx");%>
            </div>
        <%} %>
        <script type="text/javascript">
            $(document).ready(function() {
                $('#searchMicroBlog,#searchUser').click(function() {
                    var $s_form = $('#mb_search');
                    if ($.trim($s_form.find("input[type=text]").val()).length > 0) {
                        $s_form.attr("action", $(this).attr('href'));
                        $s_form.submit();
                        return false;
                    }
                });
                
                $('input[name=type]').click(function() {
                    $('#mb_search').submit();
                });

                $("a[name=follow]").click(function() {
                    var $follow = $(this);
                    if ($(this).attr("value") > 0) {
                        $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                            $follow.html('<%=GetResourceString("Action_CancelFollow",applicationID)%>').attr("value", 0).parents("span.tn-button").unbind('mouseover').unbind('mouseout').removeClass("tn-button-default-hover tn-button-default").addClass("tn-button-secondary").mouseover(function() {
                                $(this).removeClass('tn-button-secondary').addClass('tn-button-secondary-hover');
                            }).mouseout(function() {
                                $(this).removeClass('tn-button-secondary-hover').addClass('tn-button-secondary');
                            });
                        });
                    }
                    else {
                        $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $follow.attr("id") }, function(data) {
                            $follow.html('<%=GetResourceString("Action_Follow",applicationID)%>').attr("value", 1).parents("span.tn-button").unbind('mouseover').unbind('mouseout').removeClass("tn-button-secondary-hover tn-button-secondary").addClass("tn-button-default").mouseover(function() {
                                $(this).removeClass('tn-button-default').addClass('tn-button-default-hover');
                            }).mouseout(function() {
                                $(this).removeClass('tn-button-default-hover').addClass('tn-button-default');
                            });
                        });
                    }
                });

            });
        </script>
    </div>
</div>

</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
    <%Html.RenderAction<MicroBlogController>(n => n.Control_TopMicroBlogTopic(10)); %>
</asp:content>
