﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<MicroBlogThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="MicroBlogDomainPageShowMicroBlog"
</asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%> 
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   User currentDomainUser = Users.GetUser(userDomainName, false);
   int BlogApplicationID = ApplicationIDs.Instance().MicroBlog();
   int applicationID = ApplicationIDs.Instance().MicroBlog();
   string errorMessage = ViewData.GetString("errorMessage", string.Empty);
   if (Model != null)
   {
       bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
       if (errorAuditingStatus || !string.IsNullOrEmpty(errorMessage))
       {%>
<div class="problemHint privacyMessage">
    <div class="tn-widget">
        <div class="tn-cue-highlight tn-corner-all tn-message-box">
            <span class="tn-helper-right"></span>
            <span class="tn-helper-left">
                <span class="tn-icon tn-icon-exclamation"></span>
            </span>
            <div class="tn-helper-flowfix">
                <% Response.Write(errorMessage); %>
                <%if (CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator))
                  {%>
                <%=GetResourceString("Description_AdministrationManageArticle", applicationID)%>
                <a href="<%=SPBUrlHelper.Action("updateMicroBlogAuditingStatuses","MicroBlog",new RouteValueDictionary{{"threadID", Model.ThreadID},{"userDomainName",userDomainName}})%>"
                    title="<%=GetResourceString("Description_CurrentArticlePassAuditing", applicationID) %>"
                    id="SetIsPassButton">
                    <%=GetResourceString("Label_IsPastVote",applicationID)%></a>
                <%}%>
            </div>
        </div>
    </div>
    <div class="tn-blank10">
    </div>
</div>
<%}
       if (!errorAuditingStatus || (CurrentUser != null && (CurrentUser.UserID == Model.UserID || CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator)))
       { %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-microblog-show"
    id="ShowMicroBlog">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="spb-microblog-content">
            <p>
                <%=Model.LinkBody %></p>
            <%if (Model.HasPhoto || Model.HasVideo || Model.HasMusic)
              {%>
            <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=Model.ThreadID %>">
                <%if (Model.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(Model.ThreadID, null, MicroBlogPhotoTypes.Preview)); %>
                <%if (Model.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(Model.ThreadID, Model.ThumbnailUrl, Model.PlayUrl, false)); %>
                <%if (Model.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(Model.ThreadID, Model.PlayUrl, false)); %>
            </div>
            <%} %>
            <%MicroBlogThread originalThread = Model.GetOriginalThread;
              if (Model.OriginalThreadID > 0 && originalThread != null)
              { %>
            <div class="tn-list-item-row spb-reprint-original-box tn-bg-gray tn-border-gray">
                <p>
                    <a class="tn-user-name" href="<%=SiteUrls.Instance().MyMicroBlogs(originalThread.UserID) %>">
                        <%=originalThread.Author%>：</a><%=originalThread.LinkBody%></p>
                <%if (originalThread.HasPhoto || originalThread.HasVideo || originalThread.HasMusic)
                  {%>
                <div class="spb-media-wrap tn-helper-clearfix" id="thumb_list_<%=Model.ThreadID %>">
                    <%if (originalThread.HasPhoto) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogPhoto(Model.ThreadID, Model.OriginalThreadID, MicroBlogPhotoTypes.Preview)); %>
                    <%if (originalThread.HasVideo) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogVideo(Model.ThreadID, originalThread.ThumbnailUrl, originalThread.PlayUrl, false)); %>
                    <%if (originalThread.HasMusic) Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogMusic(Model.ThreadID, originalThread.PlayUrl, false)); %>
                </div>
                <%} %>
                <div class="tn-list-item-row">
                    <em class="tn-date">
                        <a href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>">
                            <%=Formatter.FormatFriendlyDate(originalThread.DateCreated) %></a></em><span class="tn-pipe tn-text-note">|</span><span
                                class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalForward",applicationID)%><%if (originalThread.ForwardedCount > 0) Response.Write("(" + originalThread.ForwardedCount + ")"); %></a>
                            </span>
                    <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a class="tn-action-text"
                        href="<%=SiteUrls.Instance().ShowMicroBlog(originalThread.UserID,originalThread.ThreadID) %>"><%=GetResourceString("Title_OriginalComment",applicationID)%><%if (originalThread.ReplyCount > 0) Response.Write("(" + originalThread.ReplyCount + ")"); %></a>
                    </span>
                </div>
            </div>
            <%} %>
        </div>
        <div class="spb-microblog-count tn-helper-align-right tn-helper-clearfix">
            <em class="tn-date tn-text-note tn-helper-left">
                    <%=Formatter.FormatFriendlyDate(Model.DateCreated,true) %></em>
            <span class="tn-action">
                <a id="forwardmb" href="<%=SPBUrlHelper.Action("Control_ForwardMicroBlog","MicroBlog",new RouteValueDictionary {{"threadID",Model.ThreadID}}) %>"
                    class="tn-action-text">
                    <%=GetResourceString("Action_Forward", applicationID)%>
                    <%if (Model.ForwardedCount > 0) Response.Write("(" + Model.ForwardedCount + ")");%></a>
            </span>
            <span class="tn-pipe tn-text-note">|</span><span class="tn-action"><a href="javascript:;"
                onclick="$('#microBlogCommentBody').focus();" class="tn-action-text"><%=GetResourceString("Action_Comment",applicationID)%></a>
            </span>
        </div>
        <div id="commentForLoad">
            <%Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogThreadComments(Model.ThreadID, Request.QueryString.GetInt("pageIndex", 1))); %>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#forwardmb').dialog({
            id: '',
            title: '<%=GetResourceString("Title_ForwardToMy", applicationID)%>',
            width: 300
        });

        //video_start
        $('div[name=videoThumb]').click(function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#play_video_' + tid).length > 0) {
                if ($.browser.msie)
                    $('#play_video_' + tid).show().find('div.spb-video-play').html('<embed height="416" width="450" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="' + $(this).attr("playurl") + '"></embed>');
                else
                    $('#play_video_' + tid).show().find('embed').attr("src", $(this).attr("playurl"));

                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_video_" + tid + "\">&nbsp;</div>").hide();
                $('#play_video_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogVideo","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
        });
        $("span[name=stop_Video]").live("click", function() {
            var tid = $(this).attr('tid');
            if ($.browser.msie) {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        $('a[type=Video]').click(function() {
            var $thumblist = $(this).parent().siblings('div[id*=thumb_list]');
            var tid = $thumblist.attr("id").replace(/[^0-9]/ig, "");
            $('#view_photo_' + tid).hide();
            if ($.browser.msie)
                $('#play_music_' + tid).hide().find('object').remove();
            else
                $('#play_music_' + tid).hide().find('embed').attr("src", "");  
                
            if ($('#play_video_' + tid).length > 0) {
                $thumblist.hide();

                if ($.browser.msie)
                    $('#play_video_' + tid).show().find('div.spb-video-play').html('<embed height="416" width="450" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="' + $(this).attr("playurl") + '"></embed>');
                else
                    $('#play_video_' + tid).show().find('embed').attr("src", $(this).attr("playurl"));
            }
            else {
                $thumblist.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_video_" + tid + "\">&nbsp;</div>").hide();
                $('#play_video_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogVideo","MicroBlog") %>?play=true&threadID=' + tid + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
            return false;
        });
        //video_end

        //music_start
        var playurl = '<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?autoPlay=false&audioUrl=';
        $('div[name=musicThumb]').click(function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#play_music_' + tid).length > 0) {
                if ($.browser.msie)
                    $('#play_music_' + tid).show().find('div.spb-music-play').html('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwav/cabs/flash/swflash.cab#version=6,0,40,0">'
                    + '<param name="bgcolor" value="#ffffff" />'
                    + '<param name="flashvars" value="playerMode=embedded" />'
                    + '<param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl=' + $(this).attr("playurl") + '&autoPlay=true" />'
                    + '<param name="wmode" value="window" />'
                    + '<param name="quality" value="best" />'
                    + '<embed type="application/x-shockwave-flash" width="400" height="27" src="' + $(this).attr("playurl") + '" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed></object>');
                else
                    $('#play_music_' + tid).show().find('embed').attr("src", playurl + $(this).attr("playurl"));
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_music_" + tid + "\">&nbsp;</div>").hide();
                $('#play_music_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogMusic","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
        });
        $("span[name=stop_Music]").live("click", function() {
            var tid = $(this).attr('tid');
            if ($.browser.msie) {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        $('a[type=Music]').click(function() {
            var $thumblist = $(this).parent().siblings('div[id*=thumb_list]');
            var tid = $thumblist.attr("id").replace(/[^0-9]/ig, "");
            $('#view_photo_' + tid).hide();
            if ($.browser.msie)
                $('#play_video_' + tid).hide().find('embed').remove();
            else
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
            if ($('#play_music_' + tid).length > 0) {
                $thumblist.hide();
                if ($.browser.msie)
                    $('#play_music_' + tid).show().find('div.spb-music-play').html('<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwav/cabs/flash/swflash.cab#version=6,0,40,0">'
                    + '<param name="bgcolor" value="#ffffff" />'
                    + '<param name="flashvars" value="playerMode=embedded" />'
                    + '<param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl=' + $(this).attr("playurl") + '&autoPlay=true" />'
                    + '<param name="wmode" value="window" />'
                    + '<param name="quality" value="best" />'
                    + '<embed type="application/x-shockwave-flash" width="400" height="27" src="' + $(this).attr("playurl") + '" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed></object>');
                else
                    $('#play_music_' + tid).show().find('embed').attr("src", playurl + $(this).attr("playurl"));
            }
            else {
                $thumblist.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"play_music_" + tid + "\">&nbsp;</div>").hide();
                $('#play_music_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogMusic","MicroBlog") %>?play=true&threadID=' + tid + "&playUrl=" + encodeURIComponent($(this).attr("playurl")));
            }
            return false;
        });
        //music_end

        //photo_start
        $('div[name=previewPhoto]').click(function() {
            var $vtp = $(this).parent();
            var tid = $(this).attr('tid');
            if ($('#view_photo_' + tid).length > 0) {
                $('#view_photo_' + tid).show();
                $vtp.hide();
            }
            else {
                $vtp.after("<div class=\"spb-media-wrap tn-helper-clearfix\" id =\"view_photo_" + tid + "\">&nbsp;</div>").hide();
                $('#view_photo_' + tid).load('<%=SPBUrlHelper.Action("Control_MicroBlogPhoto","MicroBlog") %>?play=true&threadID=' + $(this).attr('tid') + '&othreadID=' + $(this).attr('otid') + "&type=" + '<%=MicroBlogPhotoTypes.View %>');
            }
        });
        $("div[name=viewPhoto]").live("click", function() {
            var tid = $(this).attr('tid');
            if ($.browser.msie) {
                $('#play_video_' + tid).hide().find('embed').remove();
                $('#play_music_' + tid).hide().find('object').remove();
            }
            else {
                $('#play_video_' + tid).hide().find('embed').attr("src", "");
                $('#play_music_' + tid).hide().find('embed').attr("src", "");
            }
            $('#view_photo_' + tid).hide();
            $('#thumb_list_' + tid).show();
        });

        //photo_end
    });

</script>

<%}
   } %>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");%>     
    <%Html.RenderAction<MicroBlogController>(n => n.Control_MicroBlogInfo(userDomainName, null)); %>
    <%Html.RenderAction<MicroBlogController>(n => n.Control_TopMicroBlogTopic(10)); %>
    <%Html.RenderAction<MicroBlogController>(n => n.Control_RecommendUsersBlock(11005, 9)); %>
</asp:content>
