﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.MicroBlogDomainViewPage<IList<MicroBlogUserData>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="MicroBlog-TopUsers"
</asp:content>
<asp:content contentplaceholderid="HeaderContent" runat="server">
<%Html.RenderPartial("Controls/Header.ascx", ViewData);%>    
</asp:content>
<asp:content id="WideContentRegion" runat="server" contentplaceholderid="WideContentRegion"> 
 <%ViewData["browseSubMenu"] = (int)MicroBlogBrowseSubMenu.UserRanks;
   Html.RenderPartial("Controls/MicroBlogBrowseSubMenu.ascx", ViewData);%>
<div class="tn-grid-1-2 spb-top-users">
    <div class="tn-unit tn-first">
        <div class="tn-box tn-widget tn-widget-content tn-corner-all tn-popular">
            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                <h3 class="tn-helper-reset">
                    活跃用户排行</h3>
            </div>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <%Html.RenderAction<MicroBlogController>(n => n.Control_TopUsersRank(UserDataSortBy.ThreadCount));%>
            </div>
        </div>
    </div>
    <div class="tn-grid-1-1">
        <div class="tn-unit tn-first">
            <div class="tn-box tn-widget tn-widget-content tn-corner-all tn-popular">
                <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                    <h3 class="tn-helper-reset">
                        一周人气排行</h3>
                </div>
                <div class="tn-box-content tn-widget-content tn-corner-bottom">
                    <%Html.RenderAction<MicroBlogController>(n => n.Control_TopUsersRank(UserDataSortBy.StageFollowerCount));%>
                </div>
            </div>
        </div>
        <div class="tn-unit">
            <div class="tn-box tn-widget tn-widget-content tn-corner-all tn-popular">
                <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                    <h3 class="tn-helper-reset">
                        人气用户排行</h3>
                </div>
                <div class="tn-box-content tn-widget-content tn-corner-bottom">
                    <%Html.RenderAction<MicroBlogController>(n => n.Control_TopUsersRank(UserDataSortBy.FollowerCount)); %>
                </div>
            </div>
        </div>
    </div>
</div>
</asp:content>
