﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="tagIt" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
<%
    string tagInputName = ViewData.GetString("TagInputName", "appTag");
    string applicationTagItemKey = ViewData.GetString("applicationTagItemKey", string.Empty);

    List<string> selectedUserTags = ViewData.Get<List<string>>("SelectedUserTags");
    Dictionary<string, KeyValuePair<int, ApplicationTag>> myTags = ApplicationTagManager.Instance(applicationTagItemKey).GetTopApplicationTags(30, ApplicationTagsSortBy.ItemCount, null);
    string getTagsJosnUrl = SPBUrlHelper.Action("GetAppTagsJosn", "Channel", new RouteValueDictionary { { "applicationTagItemKey", applicationTagItemKey } });

    string selectedUserTagValue = "{}";
    string myTagsValue = "{}";
    System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
    if (selectedUserTags != null && selectedUserTags.Count > 0)
    {
        selectedUserTagValue = serializer.Serialize(selectedUserTags.Select(n => new { value = n }));
    }
    if (myTags != null && myTags.Count > 0)
    {
        myTagsValue = serializer.Serialize(myTags.Select(n => new { value = n.Key }));
    }
%>
<div class="tn-expand-control">
    <input id="<%=tagInputName %>" type="text" />
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#<%=tagInputName %>").autoSuggest("<%=getTagsJosnUrl %>", 
        {
            asHtmlID:"<%=tagInputName %>",
            selectionLimit:5,
            minChars: 1,
            keyDelay: 600,
            preFill: <%=selectedUserTagValue %>,
            allSelectData:<%=myTagsValue %>,
            enableManualAdd: true
        });
    });
</script>

