﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<WidgetInstance>" %>
<%
    HyperLinkEntity titleHyperLink = ViewData.Get<HyperLinkEntity>("titleHyperLink");
    HyperLinkEntity shortcutHyperLink = ViewData.Get<HyperLinkEntity>("shortcutHyperLink");
    bool isDesignMode = ViewData.GetBool("isDesignMode", false);
%>
<%
    if (isDesignMode || Model.HasBorder)
    {
%>
<div id="widget_<%=Model.InstanceID %>" <%
    if (isDesignMode)
    {
        Response.Write(string.Format(" _instanceID=\"{0}\" ", Model.InstanceID));
        if (Model.IsFrozen)
        {
            Response.Write(" class='tn-box tn-widget tn-widget-content tn-corner-all spb-widget widgetDisabled'  onmouseout=\"this.className='tn-box tn-widget tn-widget-content tn-corner-all spb-widget widgetDisabled'\" onmouseover=\"this.className='tn-box tn-widget tn-widget-content tn-corner-all spb-widget spb-widget-hover widgetDisabled'\" ");
        }
        else
        {
            Response.Write(" class='tn-box tn-widget tn-widget-content tn-corner-all spb-widget'  onmouseout=\"this.className='tn-box tn-widget tn-widget-content tn-corner-all spb-widget'\" onmouseover=\"this.className='tn-box tn-widget tn-widget-content tn-corner-all spb-widget spb-widget-hover'\" ");
        }
    }
    else
    {
        Response.Write("class='tn-box tn-widget tn-widget-content tn-corner-all spb-widget'");
    } 
    %>>
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <% 
            if (isDesignMode)
            {
                if (!Model.IsFrozen)
                {
                    Response.Write(string.Format("<a href=\"javascript:;\" class=\"tn-icon tn-icon-cross tn-helper-right\" title=\"{0}\" onclick='deleteWidgetInstance({1})'>{0}</a>", GetResourceString("Button_Remove"), Model.InstanceID));
                }

                if (!Model.ReadOnly)
                {
                    Response.Write(string.Format("<a href=\"javascript:;\" class=\"tn-icon tn-icon-set tn-helper-right\"  title=\"{1}\" onclick=\"toggleWidgetSettings({0})\">{1}</a>", Model.InstanceID, GetResourceString("Button_Set")));
                }
            }
            if (!isDesignMode && shortcutHyperLink != null)
            {
                Response.Write(string.Format("<span class=\"tn-helper-right\"><a href=\"{0}\" title=\"{1}\">{2}</a></span>", shortcutHyperLink.NavigateUrl, shortcutHyperLink.ToolTips, shortcutHyperLink.Text));
            }
        %>
        <h3 class="tn-helper-reset">
            <%
                if (titleHyperLink != null)
                {
                    Response.Write(string.Format("<a href=\"{0}\" title=\"{1}\">{2}</a>", titleHyperLink.NavigateUrl, titleHyperLink.ToolTips, titleHyperLink.Text));
                }
                else
                {
                    string moudlelTitle = Model.Title;
                    if (string.IsNullOrEmpty(moudlelTitle))
                        moudlelTitle = Model.WidgetName;

                    Response.Write(Model.ProcessResourceToken(moudlelTitle, CurrentUserLanguage));
                } 
            %>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <%
            if (isDesignMode && !Model.ReadOnly)
            {
        %>
        <div id="<%=Model.InstanceID %>_WidgetSettingsPanel" class="spb-widget-set-panel tn-border-gray tn-border-bottom"
            style="display: none;">
            <form class="widgetSettingsForm" method="post" action="<%=SPBUrlHelper.Action("UpdateWidgetInstanceSettings", "Channel", new RouteValueDictionary() { { "instanceID", Model.InstanceID } }) %>">
            <table>
                <%
                    foreach (var userPref in Model.UserPrefDictionary.Values)
                    {
                        if (userPref.Datatype != WidgetUserPrefDataTypes.Hidden)
                        {
                %>
                <tr>
                    <th>
                        <%=Model.ProcessResourceToken(userPref.DisplayName, CurrentUserLanguage)%>
                    </th>
                    <td>
                        <%
                            switch (userPref.Datatype)
                            {
                                case WidgetUserPrefDataTypes.Bool:
                                    Response.Write(string.Format("<input id=\"{0}_true\" name=\"{0}\" class=\"tn-radiobutton\" type=\"radio\" value=\"true\" ", userPref.Name));
                                    if (userPref.DefaultValue.Equals(bool.TrueString, StringComparison.InvariantCultureIgnoreCase))
                                        Response.Write(" checked=\"checked\" ");

                                    Response.Write(string.Format(" /><label for=\"{0}_true\">" + GetResourceString("Common_Yes") + "</label>", userPref.Name));

                                    Response.Write(string.Format("<input id=\"{0}_false\" name=\"{0}\" class=\"tn-radiobutton\" type=\"radio\" value=\"false\" ", userPref.Name));
                                    if (userPref.DefaultValue.Equals(bool.FalseString, StringComparison.InvariantCultureIgnoreCase))
                                        Response.Write(" checked=\"checked\" ");

                                    Response.Write(string.Format(" /><label for=\"{0}_false\">" + GetResourceString("Common_No") + "</label>", userPref.Name));
                                    break;
                                case WidgetUserPrefDataTypes.Enum:
                                    Response.Write(string.Format("<select class=\"tn-dropdownlist\" id=\"{0}\" name=\"{0}\" >", userPref.Name));
                                    foreach (var item in userPref.ReferenceDictionary)
                                    {
                                        Response.Write(string.Format("<option value=\"{0}\" ", item.Key));
                                        if (item.Key.Equals(userPref.DefaultValue, StringComparison.InvariantCultureIgnoreCase))
                                            Response.Write(" selected=\"selected\" ");

                                        Response.Write(string.Format(" >{0}</option>", item.Value));
                                    }
                                    Response.Write("</select>");
                                    break;
                                case WidgetUserPrefDataTypes.String:
                                    Response.Write(string.Format("<input class=\"tn-textbox tn-input-medium tn-border-gray\" id=\"{0}\" name=\"{0}\" value=\"{1}\" type=\"text\" />", userPref.Name, Model.ProcessResourceToken(userPref.DefaultValue, CurrentUserLanguage)));
                                    break;
                            }
                        %>
                    </td>
                </tr>
                <%
                    }
                    }
                %>
                <tr>
                    <th>
                        <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %>
                    </th>
                    <td><div class="tn-textarea-wrap">
                        <textarea class="textareaBox" name="WidgetContent" id="WidgetContent"><%=Model.Content %></textarea>
                        <span style="display:none"></span>
                        </div>
                    </td>
                </tr>
                <tr>
                    <th>&nbsp;
                        
                    </th>
                    <td>
                        <%=SPBHtmlHelper.Instance().SubmitButton("save" + Model.InstanceID, GetResourceString("Button_Save"), ButtonSizes.Default, null, null)%>
                        <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary {{ "onclick", "toggleWidgetSettings(" + Model.InstanceID.ToString() + ")" } })%>
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <% }%>
        <%= Model.Content %>
    </div>
</div>
<%
    }
    else if (!Model.HasBorder)
    {
        Response.Write(Model.Content);
    }
    
    
    
    
%>
