﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ManageThreadAttachmentsModel>" %>
<%
    if (TempData["StatusMessageData"] != null)
    {
        StatusMessageData statusMessageData = (StatusMessageData)TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));

        if (statusMessageData.MessageType  == StatusMessageType.Success)
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData,2000, false));
        }
        else
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        TempData["StatusMessageData"] = null;
    } %>
<% if (Model.Attachments != null && Model.Attachments.Count > 0)
   { %>
<div id="attachmentListDiv_<%=Model.IsImage %>">
    <div class="<% if (Model.IsImage) Response.Write("spb-pic-wrapper"); else Response.Write("spb-attachment-wrapper"); %>">
        <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
            <%
       SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
       foreach (var attachment in Model.Attachments)
       {
           if (Model.IsImage != attachment.IsImage)
               continue;
           string renderHtml;
           if (attachment.IsImage)
           {
               if (siteSettings.UseUBBRenderInlinedImage)
               {
                   renderHtml = string.Format("[attachimg]{0}[/attachimg]", attachment.AttachmentID);
               }
               else
               {
                   if (siteSettings.InlinedImageWidth > 0 && attachment.Width > siteSettings.InlinedImageWidth)
                       renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' width='{2}' /></a>", Model.GetAttachmentUrl(attachment.AttachmentID), attachment.FriendlyFileName, siteSettings.InlinedImageWidth);
                   else if (siteSettings.InlinedImageHeight > 0 && attachment.Height > siteSettings.InlinedImageHeight)
                       renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' height='{2}' /></a>", Model.GetAttachmentUrl(attachment.AttachmentID), attachment.FriendlyFileName, siteSettings.InlinedImageHeight);
                   else
                       renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' /></a>", Model.GetAttachmentUrl(attachment.AttachmentID), attachment.FriendlyFileName);
                   renderHtml = WebUtils.HtmlEncode(renderHtml);
               }
           }
           else
           {
               renderHtml = string.Format("[attach]{0}[/attach]", attachment.AttachmentID);
               
           }                   
                    
            %>
            <li class="tn-photo-item">
                <input type="hidden" name="renderHtml" value="<%=renderHtml %>" />
                <span class="tn-check-widget tn-widget-content tn-border-gray"><span class="tn-icon tn-icon-accept">
                </span></span>
                <p class="tn-photo-wrap tn-widget-content tn-border-gray">
                    <a href="javascript:;">
                        <%=Model.ShowAttachmentThumbnail(attachment, ContentTypeThumbnailSize.Large)%><span></span></a></p>
                <p class="tn-text-heading">
                    <a href="<%=Model.GetAttachmentUrl(attachment.AttachmentID) %>" title="<%=attachment.FriendlyFileName %>"
                        target="_blank">
                        <%=attachment.FriendlyFileName %></a>
                </p>
                <% if (attachment.IsImage)
                   {   %>
                <p>
                    <span class="tn-action">
                        <input id="titleAttachmentCheckbox_<%=attachment.AttachmentID%>" name="titleAttachmentCheckbox"
                            value="<%=attachment.AttachmentID %>" type="checkbox" <%if (Model.UserFeaturedImageAttachmentID==attachment.AttachmentID) Response.Write("checked=\"checked\""); %> />
                        <label for="titleAttachmentCheckbox_<%=attachment.AttachmentID%>">
                            <%=GetResourceString("Label_SetTitlePicture")%></label>
                    </span>
                </p>
                <%} %>
                <% if (attachment.IsImage)
                   {   %>
                <p>
                    <span class="tn-action">
                        <%} %>
                        <a href="javascript:;" class="tn-action-text" onclick="if (confirm('<%=string.Format(GetResourceString("Message_Pattern_ConfirmDeleteAttachment"),attachment.FriendlyFileName) %>')) { $('#attachmentListDiv_<%=Model.IsImage %>').parent().load('<%=Model.DeleteAttachmentUrl(attachment.AttachmentID,Model.IsImage) %>',{random:'bsie6'});return false;}">
                            <%=GetResourceString("Action_Delete")%></a>
                        <% if (attachment.IsImage)
                           {   %></span>
                    <p>
                        <%} %>
            </li>
            <%}%>
        </ul>
    </div>
    <div class="tn-form tn-label-right tn-border-gray tn-border-top">
        <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label">
            </label>
            <%=SPBHtmlHelper.Instance().Button("insertHtmlEditorButton_"+Model.IsImage,GetResourceString("Action_InsertEditor") , ButtonSizes.Default, HighlightStyles.Primary, null,new RouteValueDictionary {{"class","dialogClose"}})%>
            <%=SPBHtmlHelper.Instance().CloseButton(new RouteValueDictionary {{"class","dialogClose"} })%>
        </div>
    </div>
</div>
<%} %>
<%string selectItemTip = GetResourceString("Message_PleaseClickToInsertThePictureSelected");
  if (!Model.IsImage)
      selectItemTip = GetResourceString("Message_PleaseClickToInsertTheAttachmentSelected"); %>
<script type="text/javascript">
    $(document).ready(function() {
        $("#insertHtmlEditorButton_<%=Model.IsImage %>", $("#attachmentListDiv_<%=Model.IsImage %>")).click(function() {
            var $selectedItems = $("li.tn-photo-item", $("#attachmentListDiv_<%=Model.IsImage %>")).filter(".tn-selected");
            if ($selectedItems.length == 0) {
                alert("<%=selectItemTip %>");
                return false;
            }
            $selectedItems.find("input[type='hidden'][name='renderHtml']").each(function() {
            <% if(Model.IsImage){ %>
                InsertContentToHtmlEditor('<p style="text-align: center;">' + $(this).attr("value") + '</p>');
                <%}else{ %>
                InsertContentToHtmlEditor($(this).attr("value") + '<br/>');                
                <%} %>
                $(this).siblings(".tn-photo-wrap").click();
            });
        });
        $("input[name='titleAttachmentCheckbox']", $("#attachmentListDiv_<%=Model.IsImage %>")).click(function() {
            if (this.checked) {
                $("input[name='titleAttachmentCheckbox']", $("#attachmentListDiv_<%=Model.IsImage %>")).not(this).removeAttr("checked");
                if ($("#<%=Model.FeaturePicAttachmentIDControlName %>").length)
                    $("#<%=Model.FeaturePicAttachmentIDControlName %>").attr("value", $(this).attr("value"));
            }
        });
    });
</script>
