﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PersonUser>" %>
<div class="tn-card tn-card-complete">
    <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-left">
        <div class="tn-bubble-box-arrow">
            <b class="tn-arrow-b1 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b2 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b3 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b4 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b5 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b6 tn-widget-content tn-bg-light"></b>
            <b class="tn-arrow-b7 tn-widget-content tn-bg-light"></b>
        </div>
        <div class="tn-bubble-box-content tn-widget-content tn-bg-light tn-corner-all">
            <%
                if (Model != null)
                {
                    string controlID = ViewData.GetString("controlID", string.Empty);
                    int applicationID = ApplicationIDs.Instance().User();
            %>
            <div class="tn-showcase tn-helper-clearfix">
                <div class="tn-helper-left">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(Model.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Card)%></div>
                <div class="tn-info">
                    <div class="tn-id-name">
                        <strong>
                            <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(Model.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>">
                                <%=SPBHtmlHelper.Instance().UserDisplayName(Model.UserID,true) %></a></strong></div>
                    <%string microblog = MicroBlogUserDatas.GetUserData(Model.UserID, false).MostRecentThreadBody;
                      if (!string.IsNullOrEmpty(microblog))
                      { %>
                    <div class="spb-i-said">
                        &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                        <%=microblog%>
                        <span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span>
                    </div>
                    <%}%>
                    <div class="tn-info-part">
                        <dl class="tn-text-note">
                            <dt>
                                <%=GetResourceString("Label_LastActivity",applicationID) %><%=GetResourceString("Common_Colon") %></dt>
                            <dd>
                                <%=Formatter.FormatDate(Model.LastActivity,false) %></dd>
                        </dl>
                        <dl class="tn-text-note">
                            <dt></dt>
                            <dd>
                                <%=string.Format(GetResourceString("Description_Pattern_FriendCount",applicationID),Model.FriendCount) %>
                            </dd>
                        </dl>
                        <dl class="tn-text-note">
                            <dt></dt>
                            <dd>
                                <%=Formatter.FormatArea(Model.NowAreaCode, true)%></dd>
                        </dl>
                    </div>
                </div>
            </div>
            <%if (CurrentUser != null && Model.UserID != CurrentUser.UserID)
              {%>
            <div class="tn-actions tn-bg-light tn-border-light tn-border-top">
                <% if (!Friends.IsFriend(CurrentUser.UserID, Model.UserID))
                   {%>
                <span class="tn-button tn-button-default">
                    <span class="tn-first-child">
                        <a class="tn-button-text addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,Model.UserID)%>">
                            <%= GetResourceString("Action_AddFriend")%></a>
                    </span>
                </span>
                <%} %>
                <span class="tn-button tn-button-default">
                    <span class="tn-first-child">
                        <a class="tn-button-text" href="<%=SiteUrls.Instance().NewMessage(CurrentUser.UserName,Model.UserID) %>">
                            <%=GetResourceString("Action_SendMessage",applicationID)%></a>
                    </span>
                </span>
                <%if (CurrentUser != null && Model.UserID != CurrentUser.UserID)
                  {
                      if (!MicroBlogFollows.IsFollow(CurrentUser.UserID, Model.UserID))
                      {
                %>
                <span class="tn-button tn-button-default">
                    <span class="tn-first-child">
                        <a id="addFavorite_<%=controlID %>_<%=Model.UserID %>" class="tn-button-text" href="javascript:;"
                            value="<%=Model.UserID %>">
                            <%=GetResourceString("Action_CollecteTheUser",applicationID)%>
                        </a>
                    </span>
                </span>
                <%}
                  } %>
            </div>
            <%}%>

            <script type="text/javascript">
    $(document).ready(function() {
        $('.addFriendModal').nyroModal({
            resizeable: true
        });
        
        $('#addFavorite_<%=controlID %>_<%=Model.UserID %>').one("click",function() {
            $.get('<%= SPBUrlHelper.Action("FollowUser", "MicroBlog")%>', { userID: $(this).attr("value") }, function(data) {
                  $("#addFavorite_<%=controlID %>_<%=Model.UserID %>").text("<%=GetResourceString("Label_AlreadyCollected",applicationID)%>");
              });
        });
    });
            </script>

            <%
                }
            %>
        </div>
    </div>
</div>
