﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<div>
    <% string uploadUrl = ViewData.GetString("uploadUrl");
       string flashUrl = ViewData.GetString("flashUrl");
       int associateID = (int)ViewData["associateID"];
       string fileTypes = (string)ViewData["fileTypes"];
       string attributes = (string)ViewData["attributes"];
       int fileQueryLimit = (int)ViewData["fileQueryLimit"];
       string fileSizeLimit = (string)ViewData["fileSizeLimit"];
    %>
    <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
        SetExpireDays="30" />
    <script type="text/javascript">
        var swfu;
        //需要设置的参数：
        //upload_url：处理上传文件的Url，
        //file_types：能够上传的文件类型，例如："*.jpg;*.gif" 用英文分号隔开，
        //file_queue_limit：允许排队的文件总数，0为不限制 ，
        //file_size_limit：单个文件大小的限制 参数接收一个单位，有效的单位有B、KB、MB、GB，默认单位是KB。例如: 2147483648 B, 2097152, 2097152KB, 2048 MB, 2 GB
        //attributes：需要传给后端进行处理的控件ID，例如："categoryID;tagName"
        window.onload = function () {
            var settings = {
                flash_url: '<%=flashUrl %>',
                upload_url: '<%=uploadUrl %>',
                post_params: {
                    "currentUserID": "<%=EncryptManager.EncryptTokenForInviteFriend(Globals.GetCurrentUser().UserID.ToString()) %>"
                },
                file_size_limit: '<%=fileSizeLimit %>',
                file_types: '<%=fileTypes %>',
                file_types_description: "All Files",
                file_queue_limit: '<%=fileQueryLimit %>',
                custom_settings: {
                    progressTarget: "fsUploadProgress",
                    cancelButtonId: "btnCancel"
                },
                debug: false,

                // Button settings
                button_image_url: '<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/Images/upload-button.png") %>', // Relative to the Flash file
                button_width: "140",
                button_height: "40",
                button_placeholder_id: "spanButtonPlaceHolder",
                button_text: '<span class="theFont"><%=GetResourceString("Common_Browse")%></span>',
                button_text_style: ".theFont { font-size: 14px; font-weight: bold; text-align: center; color:#333333; }",
                button_text_left_padding: 0,
                button_text_top_padding: 10,

                // The event handler functions are defined in handlers.js
                file_queued_handler: fileQueued,
                file_queue_error_handler: fileQueueError,
                file_dialog_complete_handler: fileDialogComplete,
                upload_start_handler: uploadStart,
                upload_progress_handler: uploadProgress,
                upload_error_handler: uploadError,
                upload_success_handler: function (file, serverData) {
                    var serverData = eval('(' + serverData + ')');
                    var progress = new FileProgress(file, this.customSettings.progressTarget);
                    if (!serverData.ok && serverData.message) {
                        progress.setError();
                        progress.toggleCancel(false);
                        progress.setStatus(serverData.message);
                        this.customSettings.queue_upload_count--;
                    }
                    else {
                        progress.setComplete();
                        progress.setStatus("完成.");
                    }
                },
                upload_complete_handler: uploadComplete,
                queue_complete_handler: allUploadHandler	// Queue plugin event
            };
            swfu = new SWFUpload(settings);
        };
        var attributes = '<%=attributes %>';

        function uploadAttachmentsStart() {
            var attributesArray = attributes.split(";");

            $(attributesArray).each(function () {
                if (this == "ynPublic" || this == "onlyAllowRegisteredUserDownload") {

                    swfu.addPostParam($("[name='" + this + "']").attr("name"), $("[name='" + this + "']").attr("checked"));
                }
                else {
                    swfu.addPostParam($("[name='" + this + "']").attr("name"), $("[name='" + this + "']").attr("value"));
                }

            });

            swfu.addPostParam('associateID', '<%=associateID %>');
            swfu.startUpload();
        }
	     

    </script>
    <script type="text/jscript">


    </script>
    <div id="flashUploadFiles">
        <div id="fileUploadManageDiv">
            <span id="spanButtonPlaceHolder"></span><a id="btnCancel" class="spb-upload-button"
                disabled="disabled" onclick="swfu.cancelQueue();" href="javascript:;">
                <%=GetResourceString("Button_ClearList",ApplicationIDs.Instance().File()) %></a>
        </div>
        <div class="fieldset flash" id="fsUploadProgress">
            <span class="legend">
                <%=GetResourceString("Description_UploadList",ApplicationIDs.Instance().File())%></span>
        </div>
        <div class="legend" id="divStatus">
        </div>
    </div>
</div>
