﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<div>
    <% string uploadUrl = ViewData.GetString("uploadUrl");
       string flashUrl = ViewData.GetString("flashUrl");
       int associateID = (int)ViewData["associateID"];
       string fileTypes = (string)ViewData["fileTypes"];
       string fileSizeLimit = (string)ViewData["fileSizeLimit"];
       int applicationID = ApplicationIDs.Instance().User();
       string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
       string cropAvatarUrl = ViewData.GetString("cropAvatarUrl", SPBUrlHelper.Action("CropAvatar", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName } }));
    %>
    <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
        SetExpireDays="30" />
    <script type="text/javascript">
        var swfu;
        //需要设置的参数：
        //upload_url：处理上传文件的Url，
        //file_types：能够上传的文件类型，例如："*.jpg;*.gif" 用英文分号隔开，
        //file_queue_limit：允许排队的文件总数，0为不限制 ，
        //file_size_limit：单个文件大小的限制 参数接收一个单位，有效的单位有B、KB、MB、GB，默认单位是KB。例如: 2147483648 B, 2097152, 2097152KB, 2048 MB, 2 GB
        //attributes：需要传给后端进行处理的控件ID，例如："categoryID;tagName"
        window.onload = function () {
            var settings = {
                flash_url: '<%=flashUrl %>',
                upload_url: '<%=uploadUrl %>',
                post_params: {
                    "currentUserID": "<%=EncryptManager.EncryptTokenForInviteFriend(Globals.GetCurrentUser().UserID.ToString()) %>"
                },
                file_size_limit: '<%=fileSizeLimit %>',
                file_types: '<%=fileTypes %>',
                file_types_description: "All Files",
                file_queue_limit: '1',
                custom_settings: {
                    progressTarget: "fsUploadProgress"
                },
                debug: false,

                // Button settings
                button_image_url: '<%=WebUtils.ResolveUrl("~/Themes/Shared/Styles/Images/upload-button.png") %>', // Relative to the Flash file
                button_width: "140",
                button_height: "40",
                button_placeholder_id: "spanButtonPlaceHolder",
                button_text: '<span class="theFont"><%=GetResourceString("Common_Browse")%></span>',
                button_text_style: ".theFont { font-size: 14px; font-weight: bold; text-align: center; color:#333333; }",
                button_text_left_padding: 0,
                button_text_top_padding: 10,

                // The event handler functions are defined in handlers.js
                file_queued_handler: fileQueued,
                file_queue_error_handler: fileQueueError,
                file_dialog_complete_handler: uploadAttachmentsAction,
                upload_start_handler: uploadStart,
                upload_progress_handler: uploadProgress,
                upload_error_handler: uploadError,
                upload_success_handler: function (file, serverData) {
                    var serverData = eval('(' + serverData + ')');
                    if (serverData.ok)
                        window.location.href = "<%=cropAvatarUrl %>";
                    else if (serverData.refresh)
                        refresh();
                    else {
                        var progress = new FileProgress(file, this.customSettings.progressTarget);
                        progress.setError();
                        progress.toggleCancel(false);
                        progress.setStatus(serverData.message ? serverData.message : "上传出错");
                    }
                }
            };
            swfu = new SWFUpload(settings);
        };
        function uploadAttachmentsAction() {
            swfu.addPostParam('associateID', '<%=associateID %>');
            swfu.startUpload();
        }
    </script>
    <div id="flashUploadFiles">
        <div id="fileUploadManageDiv">
            <span id="spanButtonPlaceHolder"></span>
            <%if (ViewData.GetBool("canCropAvatar", false))
              {   
            %>
            <a href="<%=cropAvatarUrl %>" class="spb-upload-button">
                <%=GetResourceString("Action_ReCutOutAvatar",applicationID)%></a>
            <%} %>
        </div>
        <br />
        <%--<div id="fsUploadProgress" class="spb-upload-fieldset tn-border-gray tn-border-top">
            <span class="spb-upload-legend"></span>
        </div>--%>
    </div>
</div>
