﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.spb.tabs.js"
    SetExpireDays="30" />
<%
    Application fileApplication = Applications.GetApplication(ApplicationIDs.Instance().File());
    string manageAttachmentsUrl = Html.GetParameterFromRouteDateOrQueryString("manageAttachmentsUrl");// 附件管理列表Url
    bool isImage = Html.GetParameterFromRouteDateOrQueryString<bool>("isImage");
%>
<div id="userContentSelectorTab_<%=isImage %>" class="tn-tabs tn-widget <% if (isImage) Response.Write("spb-insert-pic"); else Response.Write("spb-insert-attachment"); %>">
    <ul class="tn-tabs-nav tn-helper-reset tn-helper-clearfix">
        <li><a href="<%=manageAttachmentsUrl %>"><span>
            <%=GetResourceString("Title_ManageAttachments")%></span></a></li>
        <% if (isImage)
           { %>
        <li><a href="#insertRemotePhoto"><span>
            <%=GetResourceString("Lable_FromTheNetworkAddress") %></span></a></li>
        <li><a href="<%=SPBUrlHelper.Action("UserContentSelector_ListPhotos","ChannelPhoto") %>">
            <span>
                <%=GetResourceString("Title_MyPhotos") %></span></a></li>
        <%}
           else
           { %>
        <% if (fileApplication.IsEnabled && ((CurrentUser.UserType == UserTypes.PersonUser && fileApplication.AllowPersonUser) || (CurrentUser.UserType == UserTypes.CompanyUser && fileApplication.AllowCompanyUser)))
           {%>
        <li><a href="<%=SPBUrlHelper.Action("UserContentSelector_ListFiles", "ChannelFile")%>">
            <span>
                <%=GetResourceString("Title_MyFiles")%></span></a></li>
        <%}%>
        <%} %>
    </ul>
    <% if (isImage)
       { %>
    <div id="insertRemotePhoto" style="display: none">
        <div class="tn-blank10">
        </div>
        <div class="tn-form tn-label-right">
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Lable_PictureUrl")%><%=GetResourceString("Common_Colon") %>
                </label>
                <input type="text" id="remotePhotoSrc" class="tn-textbox tn-input-long tn-border-gray"
                    value="" />
                <div class="tn-text-note">
                    <%=GetResourceString("Lable_CopyingPicturesUrl") %></div>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Lable_PictureDetails") %><%=GetResourceString("Common_Colon") %>
                </label>
                <input type="text" id="remotePhotoTitle" class="tn-textbox tn-input-long tn-border-gray"
                    value="" />
            </div>
            <%--<div class="tn-form-row">
                <label class="tn-form-label">
                    预览<%=GetResourceString("Common_Colon") %>
                </label>
                <span id="previewRemotePhoto"></span>
            </div>--%>
            <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label">
                </label>
                <%=SPBHtmlHelper.Instance().Button("insertRemotePhotoButton",GetResourceString("Action_InsertEditor") , ButtonSizes.Default, HighlightStyles.Primary, null,new RouteValueDictionary {{"class","dialogClose"}})%>
                <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary {{"class","dialogClose"} })%>
            </div>
        </div>
    </div>
    <%} %>
</div>

<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $.ajaxSetup({
            cache: false
        });

        $("#userContentSelectorTab_<%=isImage %>").spbtabs({ idPrefix: 'spb-tabs-<%=isImage %>-' });

        $(".tn-photo-wrap,span.tn-check-widget").live("click", function() {
            $(this).parents(".tn-photo-item").toggleClass("tn-selected");
            $(this).siblings(".tn-photo-wrap,span.tn-check-widget").andSelf().toggleClass("tn-border-deep tn-bg-light");
            return false;
        });
        $("#remotePhotoSrc").watermark("http://");

        $("#insertRemotePhotoButton").click(function() {
            if ($("#remotePhotoSrc").attr("value") != "http://") {
                var renderHtml = '<img src="' + $("#remotePhotoSrc").attr("value") + '" alt="' + $("#remotePhotoTitle").attr("value") + '" title="' + $("#remotePhotoTitle").attr("value") + '" />';
                InsertContentToHtmlEditor(renderHtml);
            }
            $("#remotePhotoSrc").attr("value", "");
            $.closeAllDialog();
        });
    });
</script>