﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<Attachment>>" %>
<div class="contSelectPanel">
    <ul>
        <%
            if (ViewData.Model != null)
            {
                foreach (var attachment in ViewData.Model)
                {
                    SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
                    string renderHtml;
                    if (attachment.IsImage)
                    {
                        if (siteSettings.InlinedImageWidth > 0 && attachment.Width > siteSettings.InlinedImageWidth)
                            renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' width='{2}' /></a>", SiteUrls.Instance().DownloadBlogAttachment(attachment.AttachmentID), attachment.FriendlyFileName, siteSettings.InlinedImageWidth);
                        else if (siteSettings.InlinedImageHeight > 0 && attachment.Height > siteSettings.InlinedImageHeight)
                            renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' height='{2}' /></a>", SiteUrls.Instance().DownloadBlogAttachment(attachment.AttachmentID), attachment.FriendlyFileName, siteSettings.InlinedImageHeight);
                        else
                            renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' /></a>", SiteUrls.Instance().DownloadBlogAttachment(attachment.AttachmentID), attachment.FriendlyFileName);
                    }
                    else
                    {
                        renderHtml = string.Format("<a href='{0}' taget='_blank'>{2}：{1}</a>", SiteUrls.Instance().DownloadBlogAttachment(attachment.AttachmentID), attachment.FriendlyFileName, GetResourceString("Label_Attachment"));
                    }                            
        %>
        <li id="contentItem-blogAttachment-<%=attachment.AttachmentID %>" rel="<%=WebUtils.HtmlEncode(renderHtml) %>"
            onclick="changeSelectedUserContentItem('contentItem-blogAttachment-<%=attachment.AttachmentID %>')">
            <a><span class="imgArea uiChromeComponent">
                <%=SPBHtmlHelper.Instance().ShowBlogAttachmentThumbnail(attachment, ContentTypeThumbnailSize.Large)%><span
                    class="hide"></span></span> <span class="name" title="<%=attachment.FriendlyFileName %>">
                        <%=StringUtils.Trim(attachment.FriendlyFileName, 12)%></span></a></li>
        <%                
            }
            }
        %>
    </ul>
</div>
<div class="contSelectEnter">
    <input name="insertButton" type="button"  onclick="insertContentItem()"
        value="<%=GetResourceString("Action_InsertHtmlEditer") %>" />
    <input name="cancelButton" type="button" class="inputCancel" onclick="$.nyroModalRemove()"
        value="<%=GetResourceString("Button_Cancel")%>" />
</div>
