﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<FileThread>>" %>
<div id="userContentSelectorItemList">
    <div class="spb-photos-manage spb-insert-from-my">
        <%
            List<UserCategory> userCategories = ViewData.Get<List<UserCategory>>("userCategories");
            if (userCategories != null && userCategories.Count > 0)
            {
        %>
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-border-gray tn-border-bottom">
                <%=GetResourceString("Label_ViewByCategory") %><%=GetResourceString("Common_Colon") %>
                <select name="fileUserCategoryDropDownList" id="fileUserCategoryDropDownList" class="dropDownList"
                    onchange="$('#userContentSelectorItemList').load($('#fileUserCategoryDropDownList option:selected').attr('value'))">
                    <option selected="selected" value="<%=SPBUrlHelper.Action("UserContentSelector_ListFiles","ChannelFile") %>">
                        <%=GetResourceString("Description_AllUserCategory") %></option>
                    <% foreach (var userCategory in userCategories)
                       {
                    %>
                    <option value="<%=SPBUrlHelper.Action("UserContentSelector_ListFiles","ChannelFile",new RouteValueDictionary{{"categoryID",userCategory.CategoryID}}) %>"
                        <% if (Html.GetParameterFromRouteDateOrQueryString("categoryID",0) == userCategory.CategoryID) { Response.Write("selected=\"selected\"");} %>>
                        <%=userCategory.CategoryName %></option>
                    <%
                        } %>
                </select>
            </div>
        </div>
        <%} %>
        <div class="spb-attachment-wrapper">
            <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
                <%
                    if (ViewData.Model != null)
                    {
                        foreach (var fileThread in ViewData.Model)
                        {
                            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
                            string renderHtml;
                            if (fileThread.Attachment.IsImage)
                            {
                                if (siteSettings.InlinedImageWidth != -1 && fileThread.Attachment.Width > siteSettings.InlinedImageWidth)
                                    renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' width='{2}' /></a>", SiteUrls.Instance().ShowFile(fileThread.ThreadID), fileThread.Subject, siteSettings.InlinedImageWidth);
                                else if (siteSettings.InlinedImageHeight != -1 && fileThread.Attachment.Height > siteSettings.InlinedImageHeight)
                                    renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' height='{2}' /></a>", SiteUrls.Instance().ShowFile(fileThread.ThreadID), fileThread.Subject, siteSettings.InlinedImageHeight);
                                else
                                    renderHtml = string.Format("<a href='{0}' target='_blank'><img src='{0}' alt='{1}' border='0' /></a>", SiteUrls.Instance().ShowFile(fileThread.ThreadID), fileThread.Subject);
                            }
                            else
                            {
                                renderHtml = string.Format("<a href='{0}' taget='_blank'>{2}：{1}</a>  ", SiteUrls.Instance().ShowFile(fileThread.ThreadID), fileThread.Subject, GetResourceString("Label_Attachment"));
                            }
                %>
                <li class="tn-photo-item">
                    <input type="hidden" name="renderHtml" value="<%=WebUtils.HtmlEncode(renderHtml) %>" />
                    <span class="tn-check-widget tn-widget-content tn-border-gray"><span class="tn-icon tn-icon-accept">
                    </span></span>
                    <p class="tn-photo-wrap tn-widget-content tn-border-gray">
                        <a href="javascript:;">
                            <%=SPBHtmlHelper.Instance().ShowFileAttachmentThumbnail(fileThread.Attachment, ContentTypeThumbnailSize.Large)%></a></p>
                    <p class="tn-text-heading">
                        <a href="<%=SiteUrls.Instance().ShowFile(fileThread.ThreadID) %>" title="<%=fileThread.Subject %>">
                            <%=StringUtils.Trim(fileThread.Subject, 12)%></a>
                    </p>
                </li>
                <%  }
                    }
                %>
            </ul>
        </div>
        <div class="tn-form tn-label-right tn-border-gray tn-border-top">
            <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label">
                </label>
                <%=SPBHtmlHelper.Instance().Button("insertHtmlEditorButton",GetResourceString("Action_InsertEditor") , ButtonSizes.Default, HighlightStyles.Primary, null,new RouteValueDictionary {{"class","dialogClose"}})%>
                <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary {{"class","dialogClose"} })%>
            </div>
        </div>
    </div>

    <script type="text/javascript" rel="forceLoad">
        $(document).ready(function() {
            $("#insertHtmlEditorButton", $("#userContentSelectorItemList")).click(function() {
                $("li.tn-photo-item").filter(".tn-selected").each(function() {
                    InsertContentToHtmlEditor($(this).find("input[name='renderHtml']").val());
                });
                $("li.tn-photo-item").filter(".tn-selected").find(".tn-photo-wrap").click();
            });
        });
    </script>

</div>
