﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<PhotoThread>>" %>
<%
    PhotoConfiguration galleryConfig = PhotoConfiguration.Instance(); 
%>
<div id="userContentSelectorItemList">
    <div class="tn-border-gray tn-border-top spb-photos-manage spb-insert-from-my">
        <%
            List<UserCategory> userCategories = ViewData.Get<List<UserCategory>>("userCategories");
            if (userCategories != null && userCategories.Count > 0)
            {
        %>
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-border-gray tn-border-bottom">
                <%=GetResourceString("Label_ViewByPhotoCategory") %><%=GetResourceString("Common_Colon") %>
                <select name="galleryUserCategoryDropDownList" id="galleryUserCategoryDropDownList"
                    class="tn-dropdownlist" onchange="$('#userContentSelectorItemList').load($('#galleryUserCategoryDropDownList option:selected').attr('value'))">
                    <option selected="selected" value="<%=SPBUrlHelper.Action("UserContentSelector_ListPhotos","ChannelPhoto") %>">
                        <%=GetResourceString("Description_AllPhotoCategory") %></option>
                    <% foreach (var userCategory in userCategories)
                       {
                    %>
                    <option value="<%=SPBUrlHelper.Action("UserContentSelector_ListPhotos","ChannelPhoto",new RouteValueDictionary{{"categoryID",userCategory.CategoryID}}) %>"
                        <% if (Html.GetParameterFromRouteDateOrQueryString("categoryID",0) == userCategory.CategoryID) { Response.Write("selected=\"selected\"");} %>>
                        <%=userCategory.CategoryName %></option>
                    <%
                        } %>
                </select>
            </div>
        </div>
        <%} %>
        <div class="spb-pic-wrapper">
            <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
                <%
                    if (ViewData.Model != null)
                    {
                        foreach (var photo in ViewData.Model)
                        {
                            string showPhotoUrl = SiteUrls.Instance().ShowPicture(UserID2UserNameDictionary.GetUserName(photo.OwnerUserID), photo.ThreadID);
                %>
                <li class="tn-photo-item" value="<%=photo.ThreadID %>"><span class="tn-check-widget tn-widget-content tn-border-gray">
                    <span class="tn-icon tn-icon-accept"></span></span>
                    <p class="tn-photo-wrap tn-widget-content tn-border-gray">
                        <a href="javascript:;">
                            <%=SPBHtmlHelper.Instance().ShowPicture(photo, PhotoImageType.Thumbnail)%><span></span></a></p>
                    <p class="tn-text-heading">
                        <a target="_blank" title="<%=photo.Subject %>" href="<%=showPhotoUrl %>">
                            <%=StringUtils.Trim(photo.Subject,12) %></a>
                    </p>
                </li>
                <%                
                    }
                    }
                %>
            </ul>
        </div>
        <div class="tn-form tn-label-right tn-border-gray tn-border-top">
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_PhotoSize") %><%=GetResourceString("Common_Colon") %>
                </label>
                <select name="photoImageType" id="photoImageType" class="tn-dropdownlist">
                    <option value="<%=PhotoImageType.Thumbnail %>">
                        <%=string.Format(GetResourceString("Description_Pattern_ThumbnailX"), galleryConfig.ThumbnailX)%></option>
                    <option value="<%=PhotoImageType.SecondaryThumbnail %>">
                        <%=string.Format(GetResourceString("Description_Pattern_SecondaryThumbnailX"), galleryConfig.SecondaryThumbnailX)%></option>
                    <option value="<%=PhotoImageType.Details %>" selected="selected">
                        <%=string.Format(GetResourceString("Description_Pattern_PictureDetailsX"), galleryConfig.PhotoDetailsX )%></option>
                    <option value="<%=PhotoImageType.Large %>">
                        <%=string.Format(GetResourceString("Description_Pattern_LargeX"), galleryConfig.LargeX)%></option>
                </select>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_PhotoLink")%><%=GetResourceString("Common_Colon") %>
                </label>
                <select name="photoLinkType" id="photoLinkType" class="tn-dropdownlist">
                    <option value="<%=PhotoLinkType.Nothing %>">
                        <%=GetResourceString("Enum_GalleryImageLinkType_NoLink") %></option>
                    <option value="<%=PhotoLinkType.Details %>">
                        <%=GetResourceString("Enum_GalleryImageLinkType_Details")%></option>
                    <option value="<%=PhotoLinkType.Original %>">
                        <%=GetResourceString("Enum_GalleryImageLinkType_Original")%></option>
                </select>
            </div>
            <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label">
                </label>
                <%=SPBHtmlHelper.Instance().Button("insertHtmlEditorButton",GetResourceString("Action_InsertEditor") , ButtonSizes.Default, HighlightStyles.Primary, null,new RouteValueDictionary {{"class","dialogClose"}})%>
                <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary {{"class","dialogClose"} })%>
            </div>
        </div>
    </div>

    <script type="text/javascript" rel="forceLoad">
        $(document).ready(function() {
            $("#insertHtmlEditorButton", $("#userContentSelectorItemList")).click(function() {
                var photoImageType = $("#photoImageType").val();
                var photoLinkType = $("#photoLinkType").val();
                var selectedPhotoIDs = new Array();
                $("li.tn-photo-item").filter(".tn-selected").each(function() {
                    selectedPhotoIDs.push($(this).attr("value"));
                });
                $.getJSON('<%=SPBUrlHelper.Action("GetReaderHtmls","ChannelPhoto") %>', { "selectedPhotoIDs": selectedPhotoIDs.join(","), "photoImageType": photoImageType, "photoLinkType": photoLinkType }, function(data) {
                    $(data).each(function() {
                        InsertContentToHtmlEditor(this + "<br/>");
                    });
                });
                $("li.tn-photo-item").filter(".tn-selected").find(".tn-photo-wrap").click();
            });
        });
    </script>

</div>
