﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="tagIt" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
<%
    string tagInputName = ViewData.GetString("TagInputName", "userTag");
    string userTagItemKey = ViewData.GetString("UserTagItemKey", string.Empty);

    List<string> selectedUserTags = ViewData.Get<List<string>>("SelectedUserTags");
    ICollection<UserTag> myTags = UserTagManager.Instance(userTagItemKey).GetUserTags(CurrentUser.UserID, true);

    string getTagsJosnUrl = SPBUrlHelper.Action("GetSuggestTagsJosn", "Channel", new RouteValueDictionary { { "userTagItemKey", userTagItemKey } });

    string selectedUserTagValue = "{}";
    string myTagsValue = "{}";
    System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
    if (selectedUserTags != null && selectedUserTags.Count > 0)
    {
        selectedUserTagValue = serializer.Serialize(selectedUserTags.Select(n => new { value = n }));
    }
    if (myTags != null && myTags.Count > 0)
    {
        myTagsValue = serializer.Serialize(myTags.Select(n => new { value = n.TagName }));
    }
%>
<div class="tn-expand-control">
    <input id="<%=tagInputName %>" name="<%=tagInputName %>" type="text" />
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#<%=tagInputName %>").autoSuggest("<%=getTagsJosnUrl %>", 
        {
        asHtmlID:"<%=tagInputName %>",
        minChars: 1,
        keyDelay: 600,
        selectionLimit:5,
        preFill: <%=selectedUserTagValue %>,
        allSelectData:<%=myTagsValue %>,
        enableManualAdd: true
        });
    });
   
</script>

