﻿<%@ Control Language="C#"  Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% List<UserCategory> userCategories = (List<UserCategory>)ViewData.Model;
   int currentCategoryID = ViewData.GetInt("currentCategoryID",0);
   if (currentCategoryID == 0)
   {
       currentCategoryID = TempData.GetInt("selectedCategoryID", 0);
   }
   string cssClass = ViewData.GetString("cssClass",string.Empty);
   string controlName = ViewData.GetString("controlName", "galleryCategoryDropdownList");
    %>
<span id="blogThreadUserCategoryDropdownListDiv">
<% if (userCategories != null && userCategories.Count > 0)
   {%>
<select name="<%=controlName %>" id="<%=controlName %>" class=<%=cssClass %>>
  <option value="0"><%=GetResourceString("Common_PleaseChoose") %></option>
  <% foreach (UserCategory userCategory in userCategories)
       {%>
  <option <% if (userCategory.CategoryID == currentCategoryID) Response.Write(" selected=\"selected\" "); %> value="<%=userCategory.CategoryID %>"> <%=userCategory.CategoryName%> </option>
  <% } %>
</select>
<% TempData.Remove("currentCategoryIDInDropDownlist");
   }%>
<% string currentUserDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");  %>
<span><a href="<%=SPBUrlHelper.Action("Control_EditUserCategory", "UserDomain", new RouteValueDictionary { { "userDomainName", currentUserDomainName }, { "categoryID", Html.GetParameterFromRouteDateOrQueryString("categoryID", 0) }, { "userCategoryItemKey", UserCategoryItemKeys.Instance().BlogThread() } })%>" id="newBlogThreadCategoyModelIn" ><%=GetResourceString("Common_NewUserCategory")%></a></span>
<script type="text/javascript">
    $(document).ready(function() {
        $('#newBlogThreadCategoyModelIn').nyroModal({
            resizeable: true,
            endRemove: function(elts, settings) {
                $('#blogThreadUserCategoryDropdownListDiv').load('<%=SPBUrlHelper.Action("Control_BlogThreadCategoryDropdownList","Blog",new RouteValueDictionary{{"userDomainName",currentUserDomainName},{"controlName",controlName},{"cssClass",cssClass}}) %>');
            }
        });
        })
  </script>
</span>