﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogComment>>" %>
<% 
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    bool isManager = ViewData.GetBool("isManager", false);
    BlogThread blogThread = ViewData.Get<BlogThread>("blogThread", null);
    if (blogThread == null)
        blogThread = new BlogThread();
    int BlogApplicationID = ApplicationIDs.Instance().Blog();
    int parentID = Html.GetParameterFromRouteDateOrQueryString<int>("parentID");
    RouteValueDictionary dictionary = new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", blogThread.ThreadID } };
%>
<div id="BlogThreadComments">
    <a name="ListComments" id="ListComments"></a>
    <div class="tn-list-header">
        <div class="tn-text-heading tn-border-bottom tn-border-gray">
            <%--<div class="tn-pagination tn-helper-align-right tn-helper-right"> 
        <span class="tn-page-results tn-text-note"><%=(Model.PageIndex-1)*Model.PageSize+1 %> - <%= Model.PageIndex*Model.PageSize  %> 共 <%=Model.TotalRecords %></span> 
            <%=SPBHtmlHelper.Instance().AjaxPagingButton( PaginationMode.NextPreviousFirstLast,Model.TotalRecords, Model.PageSize, Model.PageIndex, 0, SPBUrlHelper.Action("Control_BlogThreadComments", "Blog", new RouteValueDictionary(dictionary) { { "pageIndex", "{0}" } }), "PageIndexChange")%>
         </div>--%>
            <h4 class="tn-helper-reset">
                <%=GetResourceString("Common_Comment") %>
                <span class="tn-text-note">（<%if (Model != null) { Response.Write(Model.TotalRecords); } else { Response.Write("0"); } %>）</span>
            </h4>
        </div>
    </div>
    <%  
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
            TempData["StatusMessageType"] = null;
        }
    %>
    <%
        if (Model != null && Model.Records.Count > 0)
        {%>
    <ul class="tn-comments tn-helper-reset">
        <% 
            foreach (BlogComment blogComment in Model.Records)
            {
                if (!blogComment.IsApproved && (CurrentUser == null || !isManager || (blogComment.UserID != CurrentUser.UserID)))
                    continue;%>
        <a id="<%=blogComment.PostID %>"></a>
        <li class="tn-comment-item tn-border-gray tn-border-bottom">
            <div name="<%=blogComment.PostID %>" class="tn-comment tn-helper-clearfix">
                <div class="tn-comment-avatar">
                    <div class="tn-avatar">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(blogComment.UserID, AvatarSizeTypes.Small)%></div>
                </div>
                <div class="tn-item-actions">
                    <% if (CurrentUser != null && (isManager || CurrentUser.UserID == blogComment.UserID))
                       { %>
                    <a href="javascript:;" onclick="deleteTheComment('<%=SPBUrlHelper.Action("DeleteBlogThreadComment","Blog",new RouteValueDictionary(dictionary){{"postID",blogComment.PostID},{"pageIndex",Model.PageIndex}}) %>')">
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Cross, GetResourceString("Action_Delete"))%></a>
                    <%} %>
                </div>
                <div class="tn-comment-info">
                    <div class="tn-commentator">
                        <h5>
                            <% if (string.IsNullOrEmpty(blogComment.TitleUrl))
                               {%>
                            <a href="<%=SiteUrls.Instance().UserDomainHome(blogComment.UserID) %>">
                                <%=blogComment.Author%></a>
                            <%}
                               else
                               { %>
                            <a href="<%=blogComment.TitleUrl %>">
                                <%=blogComment.Author%>
                            </a>
                            <%} %>
                            <% if (blogComment.UserID <= 0) Response.Write("<em>(" + GetResourceString("Common_GuestDisplayName") + ")</em>"); %>
                        </h5>
                        <em class="tn-text-note tn-date">
                            <%=Formatter.FormatDate(blogComment.PostDate, true)%></em> <span class="tn-text-note">
                                <% if (CurrentUser != null && blogComment.UserID != CurrentUser.UserID && blogComment.ParentID <= 0)
                                   { %><em><a name="replay_<%=blogComment.PostID %>" href="javascript:;" onclick="replyComment('<%=blogComment.PostID %>');">
                                       <%=GetResourceString("Common_Reply")%></a></em><%} %></span>
                    </div>
                    <p>
                        <%=blogComment.Body%></p>
                </div>
            </div>
            <%if (blogComment.Childs != null && blogComment.Childs.Count > 0)
              {%>
            <div class="tn-replies">
                <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top">
                    <div class="tn-bubble-box-arrow">
                        <b class="tn-arrow-b1 tn-widget-content tn-border-gray"></b><b class="tn-arrow-b2 tn-widget-content tn-border-gray">
                        </b><b class="tn-arrow-b3 tn-widget-content tn-border-gray"></b><b class="tn-arrow-b4 tn-widget-content tn-border-gray">
                        </b><b class="tn-arrow-b5 tn-widget-content tn-border-gray"></b>
                    </div>
                    <div class="tn-bubble-box-content tn-widget-content tn-border-gray tn-corner-all">
                        <ul class="tn-comments tn-helper-reset" id="replay_<%=blogComment.PostID %>">
                            <a name="<%=blogComment.PostID %>" id="<%=blogComment.PostID %>"></a>
                            <%int i = 0;
                              foreach (BlogComment replayComment in blogComment.Childs)
                              {%>
                            <li class="tn-comment-item <% if (i < blogComment.Childs.Count-1) Response.Write("tn-border-gray tn-border-bottom"); %>">
                                <% i++; %>
                                <a id="<%=replayComment.PostID%>"></a>
                                <div class="tn-comment tn-helper-clearfix">
                                    <div class="tn-comment-avatar">
                                        <div class="tn-avatar">
                                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(replayComment.UserID, AvatarSizeTypes.Small)%></div>
                                    </div>
                                    <div class="tn-item-actions">
                                        <% if (CurrentUser != null && (isManager || CurrentUser.UserID == replayComment.UserID))
                                           { %>
                                        <a href="javascript:;" onclick="deleteTheComment('<%=SPBUrlHelper.Action("DeleteBlogThreadComment","Blog",new RouteValueDictionary(dictionary){{"postID",replayComment.PostID},{"pageIndex",Model.PageIndex}}) %>')">
                                            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Cross, GetResourceString("Action_Delete"))%></a>
                                        <%} %>
                                    </div>
                                    <div class="tn-comment-info">
                                        <div class="tn-commentator">
                                            <h5>
                                                <% if (string.IsNullOrEmpty(replayComment.TitleUrl))
                                                   {%>
                                                <a href="<%=SiteUrls.Instance().UserDomainHome(replayComment.UserID) %>">
                                                    <%=replayComment.Author%></a>
                                                <%}
                                                   else
                                                   { %>
                                                <a href="<%=replayComment.TitleUrl %>">
                                                    <%=replayComment.Author%>
                                                </a>
                                                <%} %>
                                                <% if (replayComment.UserID <= 0) Response.Write("<em>(" + GetResourceString("Common_GuestDisplayName") + ")</em>"); %>
                                            </h5>
                                            <em class="tn-text-note tn-date">
                                                <%=Formatter.FormatDate(replayComment.PostDate, true)%></em> <span class="tn-text-note">
                                                    <% if (CurrentUser != null && replayComment.UserID != CurrentUser.UserID && replayComment.ParentID <= 0)
                                                       { %><em><a name="<%=replayComment.PostID %>" href="javascript:replyComment('<%=replayComment.PostID %>')">
                                                           <%=GetResourceString("Common_Reply")%></a></em><%} %></span>
                                        </div>
                                        <p>
                                            <%=replayComment.Body%></p>
                                    </div>
                                </div>
                            </li>
                            <%} %>
                        </ul>
                    </div>
                </div>
            </div>
            <%} %>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_BlogThreadComments", "Blog", new RouteValueDictionary(dictionary) { { "pageIndex", "{0}" } }), "PageIndexChange")%>
    </div>
    <%} %>
</div>
<script type="text/javascript">
    function deleteTheComment(deleteUrl)
    { if (confirm('<%=GetResourceString("Message_ConfirmDeleteComment") %>')) { $('#BlogThreadComments').parent().load(deleteUrl); } }

    function setCommentApproveStatus(url) {
        $('#BlogThreadComments').parent().load(url);
    }

    function PageIndexChange(url) {
        $('#BlogThreadComments').parent().load(url);
        window.location.href = "#ListComments";
    }
    function replyComment(parentID) {
        $("li form[id^='CommentForm']").hide();
       if($("#CommentForm_"+parentID).length)
        $("#CommentForm_"+parentID).show();
        else
        {
            $.get("<%=SPBUrlHelper.Action("Control_NewBlogComment","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",blogThread.ThreadID},{"pageIndex",Model.PageIndex},{"isReplay",true}}) %>",{ parentID: parentID}, 
            function(data) {
                    if($("#replay_" + parentID).length > 0)
                        $("#replay_" + parentID + " li:last").append(data);
                    else
                        $("div[name=" + parentID + "]").append(data);
                    $("#CommentForm_"+parentID).find("textarea").text('<%=TempData.GetString("commentBody", string.Empty)%>').focus();
            });
        }
    }
    $(document).ready(function() {        
        $('.nyroModal').nyroModal({
            resizeable: true
        });
        <% if(parentID>0){ %>
        replyComment(<%=parentID %>);
        <%} %>
    });

</script>
