﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogThread>>" %>
<%int BlogApplicationID = ApplicationIDs.Instance().Blog();
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  int? categoryID = null;
  if (Html.GetParameterFromRouteDateOrQueryString<int>("categoryID") > 0)
      categoryID = Html.GetParameterFromRouteDateOrQueryString<int>("categoryID");
  string tagName = Html.GetParameterFromRouteDateOrQueryString("tagName");
  bool isSummary = Html.GetParameterFromRouteDateOrQueryString<bool>("isSummary");
  int? year = null; int? month = null; int? day = null;
  if (Html.GetParameterFromRouteDateOrQueryString<int>("year") > 0)
      year = Html.GetParameterFromRouteDateOrQueryString<int>("year");
  if (Html.GetParameterFromRouteDateOrQueryString<int>("month") > 0)
      month = Html.GetParameterFromRouteDateOrQueryString<int>("month");
  if (Html.GetParameterFromRouteDateOrQueryString<int>("day") > 0)
      day = Html.GetParameterFromRouteDateOrQueryString<int>("day");
  string boxTitle = ViewData.GetString("boxTitle", string.Empty);
  RouteValueDictionary dictionary = new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID", categoryID }, { "tagName", tagName }, { "year", year }, { "month", month }, { "day", day } };
  bool hasPermission = ViewData.GetBool("hasPermission", false);
  bool isFriend = ViewData.GetBool("isFriend", false);
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<div id="listBlogThreadsDiv">
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <%if (!string.IsNullOrEmpty(boxTitle))
          {%>
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"> <%=boxTitle%></h3>
    </div>
    <%} %>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom"> <span class="tn-text-note tn-helper-left"> <%=string.Format(GetResourceString("Description_Pattern_AllArticle", BlogApplicationID), (Model == null ? 0 : Model.TotalRecords))%> </span><span class="tn-helper-right"> <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %> <span class="tn-action tn-action-text-icon"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.BrowseDetail) %> <a href="javascript:;" class="tn-action-text" id="actionSummary"> <%=GetResourceString("Action_Summary")%></a></span> <span class="tn-action tn-action-text-icon tn-text-note tn-selected"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.BrowseList) %><a href="javascript:;" class="tn-action-text"> <%=GetResourceString("Action_List")%></a></span></span> </div>
      </div>
      <div id="loading" style="display: none" class=" tn-loading"> </div>
      <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
          <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Subject")%> </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note"> <%= GetResourceString("Common_Category") %> </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_SiteDivisionCategory")%> </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Privacy", BlogApplicationID)%> </th>
          <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_PostDate")%> </th>
          <% if (hasPermission)
                       {%>
          <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Actions")%> </th>
          <%} %>
        </tr>
        <% if (Model != null && Model.Records.Count > 0)
                   {
                       foreach (BlogThread blogThread in Model.Records)
                       {
                           if (blogThread != null)
                           {
                %>
        <tr class="tn-table-grid-row">
          <td class="tn-border-gray tn-border-bottom tn-width-auto"><div> <a href="<%=SiteUrls.Instance().ShowBlogThread(userDomainName,blogThread) %>" title="<%=blogThread.Subject %>"> <%=StringUtils.Trim(blogThread.Subject,18) %></a></div></td>
          <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap"><%if (blogThread.UserCategory != null)
                          {%>
            <a href="<%=SPBUrlHelper.Action("ListBlogThreadsByUserCategory","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",blogThread.UserCategory.CategoryID}}) %>"> <%=StringUtils.Trim(blogThread.UserCategory.CategoryName,5)%></a>
            <%} %></td>
          <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap"><% if (blogThread.SiteCategory != null)
                           {%>
            <a href="<%=SPBUrlHelper.Action("ListBlogThreadsByCategory","ChannelBlog",new RouteValueDictionary{{"categoryID",blogThread.SiteCategory.CategoryID}}) %>" title="<%=blogThread.SiteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%>"> <%=blogThread.SiteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%></a>
            <%} %></td>
          <td class="tn-border-gray tn-border-bottom tn-width-icon1"><%switch (blogThread.PrivacyStatus)
                          {
                              case PrivacyStatuses.NeedPassword:
                        %>
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword"))%>
            <%
                            break;
                              case PrivacyStatuses.OnlyFriend:
                        %>
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Limit, GetResourceString("Enum_PrivacyStatuses_OnlyFriend"))%>
            <%
                            break;
                              case PrivacyStatuses.Privacy:
                        %>
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy"))%>
            <%
                            break;
                              case PrivacyStatuses.Public:
                            break;
                              default:
                            break;
                          } %></td>
          <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap"><a href="<%=SPBUrlHelper.Action("ListBlogThreadsByYMD","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"year",blogThread.PostDate.Year},{"month",blogThread.PostDate.Month},{"day",blogThread.PostDate.Day}}) %>"> <%=Formatter.FormatDate(blogThread.PostDate,false) %></a></td>
          <% if (hasPermission)
                       {%>
          <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap"><span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("EditBlogThread","Blog",new RouteValueDictionary{{"ThreadID",blogThread.ThreadID},{"userDomainName",WebUtils.UrlEncode(userDomainName)}}) %>"> <%=GetResourceString("Action_Edit")%></a></span> <span class="tn-action"><a class="tn-action-text"
                                onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteArticle", BlogApplicationID) %>')) { $('#listBlogThreadsDiv').parent().load('<%=SPBUrlHelper.Action("DeleteBlogThread","Blog",new RouteValueDictionary(dictionary){{ "isSummary", isSummary },{"ThreadID",blogThread.ThreadID},{"pageIndex",Model.PageIndex },{"isManage",false}}) %>' )}"
                                href="javascript:;;"> <%=GetResourceString("Action_Delete")%></a></span></td>
          <%} %>
        </tr>
        <%}
                       }%>
        <%} %>
      </table>
      <div class="tn-pagination tn-helper-align-center">
        <% if (Model != null)
                   {%>
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListBlogThreads", "Blog", new RouteValueDictionary(dictionary) { { "isSummary", isSummary }, { "pageIndex", "{0}" } }), "listBlogThreadPageIndexChange")%>
        <%} %>
      </div>
    </div>
  </div>
  <script type="text/javascript">
    
     $(document).ready(function() {
	     $("tr span[menu]").menuButton({ buttonHoverClass:'ui-widget-content tn-action-hover'});
		 $('.nyroModal').nyroModal({
                resizeable: true
            });  

        $("#actionSummary").click(function() {
        showLoading();
        $("#listBlogThreadsDiv").parent().load("<%=SPBUrlHelper.Action("Control_ListBlogThreads","Blog", new RouteValueDictionary(dictionary){{"isSummary",true}}) %>");
        });
        });
        function listBlogThreadPageIndexChange(url) {
            showLoading();
            $('#listBlogThreadsDiv').parent().load(url);
        }

 
        function showLoading(){
            $("#loading").show();
            $("table.tn-table-grid").hide();
            $("div.tn-pagination").hide();
            $("#batchControlPanel").hide();
        }
        
    </script>
</div>
