﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserCategory>>" %>
<% string userDomainName = (string)ViewData["userDomainName"];  %>
<% List<UserCategory> userCategories = (List<UserCategory>)ViewData.Model;
   int BlogApplicationID = ApplicationIDs.Instance().Blog();
   bool isManager = ViewData.GetBool("isManager", false); %>
<div id="userCategoryList">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <span class="tn-helper-right">
                <% if (isManager)
                   {%>
                <a href="<%=SPBUrlHelper.Action("ManageBlogUserCategories","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex",0}}) %>">
                    <%=GetResourceString("Action_Manage")%></a>
                <%} %></span>
            <h3 class="tn-helper-reset">
                <%= GetResourceString("Common_Category") %></h3>
        </div>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <ul class="tn-helper-reset tn-list">
                <% if (userCategories != null)
                   {
                       foreach (UserCategory userCategory in userCategories)
                       { %>
                <li><a href="<%=SPBUrlHelper.Action("ListBlogThreadsByUserCategory","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",userCategory.CategoryID},{"listMode","Summary"},{"pageIndex",0}}) %>"
                    title="<%=string.Format(GetResourceString("Description_Pattern_CheckSeeCategoryArticle",BlogApplicationID),userCategory.CategoryName,userCategory.ItemCount)%>">
                    <%=userCategory.CategoryName %></a> <em class="tn-text-note">(<%=userCategory.ItemCount %>)</em></li>
                <%}
                       } %>
                       </ul>
                <% if (isManager)
                   {%>
                   <div class="tn-blank10"></div>
             <%=SPBHtmlHelper.Instance().LinkButton("newCategoryModalInBlock", GetResourceString("Button_CreateOneCategory", BlogApplicationID), SPBUrlHelper.Action("Control_EditUserCategory", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userCategoryItemKey", UserCategoryItemKeys.Instance().BlogThread() } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
                <%} %>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#newCategoryModalInBlock').nyroModal({
                resizeable: true,
                height: 200,
                width: 200,
                endRemove: function(elts, settings) {
                    $('#userCategoryList').load('<%=SPBUrlHelper.Action("ListBlogUserCategories","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"pageIndex",0}}) %>');
                }
            });
        })
    </script>

</div>
