﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ICollection<UserTag>>" %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right">
            <% bool isManager = ViewData.GetBool("isManager", false); %>
            <% if (isManager)
               {%>
            <a href="<%=SPBUrlHelper.Action("ManageBlogUserTags","Blog",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")}}) %>">
                <%=GetResourceString("Action_Manage")%></a>
            <%} %></span>
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Common_UserTag")%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <p class="tn-tags-hot">
            <% if (Model != null && Model.Count > 0)
               {%>
            <% foreach (UserTag tag in Model)
               { %>
               <span>
            <a href="<%=SiteUrls.Instance().ListBlogThreadsByUserTag(Html.GetParameterFromRouteDateOrQueryString("userDomainName"), tag.TagName) %>"
                title="<%=tag.TagName %>">
                <%=StringUtils.Trim(tag.TagName, 10)%></a> <em class="tn-text-note">(<%=tag.ItemCount.ToString()%>)</em></span>
            <% } %>
            <% } %>
        </p>
    </div>
</div>
