﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<FootPrint>>" %>
<% int threadID = ViewData.GetInt("threadID", 0);
   int showCount = ViewData.GetInt("showCount", 0);
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
<div id="footPrintsListDiv" class="tn-visitors tn-collapsible tn-collapsible-opend">
    <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
        <h4 class="tn-helper-reset">
            <%=GetResourceString("Title_FootPrint",BlogApplicationID) %></h4>
    </div>
    <div class="tn-collapsible-content">
        <ul class="tn-avatar-list tn-helper-reset">
            <%int i = 0;
              foreach (FootPrint footPrint in Model)
              {
                  i++;
                  if (footPrint == null || footPrint.User == null)
                      continue;
            %>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(footPrint.UserID, AvatarSizeTypes.Small)%></div>
                <a class="tn-text-heading" href="<%=SiteUrls.Instance().UserDomainHome(footPrint.User) %>">
                    <%=footPrint.Author%>
                </a></li>
            <%if (i == showCount)
                  break;

              }%>
        </ul>
        <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               string messageContent = (string)TempData.GetString("StatusMessageContent", string.Empty);
               Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, messageContent, 1000, true));
               TempData["StatusMessageType"] = null;
           } %>
        <% if (CurrentUser != null)
           {%>
        <p class="tn-helper-align-right">
            <%if (Model.Count <= 0)
              { %>
            <span class="tn-text-note tn-helper-left">
                <%=GetResourceString("Message_NoBodyLeaveFootPrints", BlogApplicationID)%></span><%} %>
            <a id="CreateFootPrintButton" title='<%=GetResourceString("Button_SaveFootPrint", BlogApplicationID)%>'
                href="javascript:;">
                <%=GetResourceString("Button_SaveFootPrint", BlogApplicationID) %></a>
        </p>
        <%}%>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#CreateFootPrintButton").click(function() {
            $('#footPrintsListDiv').parent().load('<%=SPBUrlHelper.Action("CreateFootPrint","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",threadID},{"showCount",showCount}}) %>');
            return false;
        });
    });            
</script>

