﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogSection>>" %>
<div id="listFriendsBlogThreadsControlDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-friends-blog">
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <% if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
               {%>
            <ul class="tn-list tn-helper-reset">
                <%foreach (BlogSection blogSection in ViewData.Model.Records)
                  {
                      if (blogSection != null && blogSection.Owner != null)
                      { %>
                <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <div class="tn-list-item-area-left">
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(blogSection.OwnerUserID,true,HyperLinkTarget._blank, AvatarSizeTypes.Small) %>
                        </div>
                    </div>
                    <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row tn-list-item-heading">
                            <h5 class="tn-helper-reset">
                                <a href="<%=SPBUrlHelper.Action("ShowBlogThread","Blog",new RouteValueDictionary{{"threadID",blogSection.MostRecentThreadID},{"userDomainName",UserID2UserNameDictionary.GetUserName(blogSection.OwnerUserID)}}) %>">
                                    <%= StringUtils.Trim(blogSection.MostRecentThreadSubject, 25)%></a></h5>
                        </div>
                        <div class="tn-list-item-row">
                            <cite><a class="tn-author" href="<%=SiteUrls.Instance().UserDomainHome(blogSection.Owner)%>">
                                <%=SPBHtmlHelper.Instance().UserDisplayName(blogSection.OwnerUserID) %></a></cite><em class="tn-date tn-text-note">
                                    <%=GetResourceString("Label_ReleaseTo",ApplicationIDs.Instance().Blog())%><%=GetResourceString("Common_Colon") %><a
                                        href="<%=SPBUrlHelper.Action("ListBlogThreadsByYMD", "Blog", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(blogSection.OwnerUserID) }, { "year", blogSection.MostRecentPostDate.Year }, { "month", blogSection.MostRecentPostDate.Month }, { "day", blogSection.MostRecentPostDate.Day } })%>"><%=blogSection.MostRecentPostDate.ToString("f")%>
                                    </a></em>&nbsp;&nbsp;<a href="<%=SPBUrlHelper.Action("ShowBlogThread","Blog",new RouteValueDictionary{{"userDomainName",UserID2UserNameDictionary.GetUserName(blogSection.OwnerUserID)},{"threadID",blogSection.MostRecentThreadID}}) %>">
                                        <%=GetResourceString("Action_FullText")%></a>
                        </div>
                        <div class="tn-list-item-row tn-list-item-summary">
                            <p class="tn-helper-reset">
                                <%=HtmlUtils.TrimHtml(blogSection.MostRecentThreadSummary,160) %>
                            </p>
                        </div>
                    </div>
                </li>
                <%}
                  } %>
            </ul>
            <%} %>
            <div class="tn-pagination tn-helper-align-center">
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListFriendsBlogThreads", "Blog", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("userDomainName") }, { "pageIndex", "{0}" } }), "summaryfriendsBlogThreadPageIndexChange")%>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function summaryfriendsBlogThreadPageIndexChange(url) {
            $('#listFriendsBlogThreadsControlDiv').load(url);
        }
    </script>

</div>
