﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<BlogAttachment>>" %>
<% List<BlogAttachment> blogAttachments = (List<BlogAttachment>)ViewData.Model;
   int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
<div id="BlogAttmentsDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            >
            <h3 class="tn-helper-reset">
                <%=GetResourceString("Title_AttachmentManage", BlogApplicationID)%></h3>
        </div>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <div class="toolbarArea">
                <%--<sbu:modallink text="添加附件" width="500" height="280" runat="Server" id="AddBlogAttachments"
                        cssclass="toolbarButton" callback="refreshCallback" />--%>
                <%=SPBHtmlHelper.Instance().LinkButton("NewBlogAttachmentModal", GetResourceString("Action_AddAttachment", BlogApplicationID), ButtonSizes.Default,HighlightStyles.Default, new RouteValueDictionary() { { "href", SPBUrlHelper.Action("NewBlogAttachment", "Blog", new RouteValueDictionary { { "userDomainName", Html.GetParameterFromRouteDateOrQueryString("UserDomainName") }, { "threadID", 0 } }) } },null)%>
            </div>
            <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_AttachmentName", BlogApplicationID)%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_Size") %>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_OnloadDate", BlogApplicationID)%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_Actions")%>
                    </th>
                </tr>
                <% foreach (BlogAttachment blogAttachment in blogAttachments)
                   { %>
                <tr class="tn-table-grid-row">
                    <td>
                        <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(blogAttachment.FileName, ContentTypeThumbnailSize.Small) %>
                        <a href="<%=SiteUrls.Instance().DownloadBlogAttachment(blogAttachment.AttachmentID) %>">
                            <%=StringUtils.Trim(blogAttachment.FriendlyFileName, 30) %></a>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <label>
                            <%=string.Format("{0}K", Math.Round(Convert.ToDouble(blogAttachment.ContentSize) / 1024, 2))%></label>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <label>
                            <%=Formatter.FormatDate(blogAttachment.DateCreated,true)%></label>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <a onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteAttachment", BlogApplicationID) %>')) { $('#BlogAttmentsDiv').load('<%=SPBUrlHelper.Action("DeleteBlogAttachment","Blog",new RouteValueDictionary{{"postID",blogAttachment.AttachmentID},{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")}}) %>')}">
                            <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/icon_delete2.gif") %>"
                                alt="<%=GetResourceString("Action_Delete")%>" />
                        </a>
                    </td>
                </tr>
                <%} %>
            </table>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#NewBlogAttachmentModal').nyroModal({
            resizeable: true,
            endRemove: function(elts, settings) { $('#BlogAttmentsDiv').load('<%=SPBUrlHelper.Action("ReloadBlogAttachments","Blog",new RouteValueDictionary{{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("UserDomainName")}}) %>'); }
        });
    });

</script>

