﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogComment>>" %>
<% PagingDataSet<BlogComment> blogComments = (PagingDataSet<BlogComment>)ViewData.Model;
   ApprovalStatuses? nowApprovalStatus = null;
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int BlogApplicationID = ApplicationIDs.Instance().Blog();
   if (ViewData["ApprovalStatus"] != null)
       nowApprovalStatus = (ApprovalStatuses)ViewData["ApprovalStatus"]; %>
<div id="ManageBlogCommentsDiv">
    <div id="manageblogComments" class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <form id="ManageBlogCommentsForm" method="post">
            <div class="tn-list-header">
                <div class="tn-toolbar tn-helper-clearfix">
                    <div class="tn-tool-form">
                        <input type="checkbox" id="TopCheckBox" onclick="checkAll(this,'BlogCommentCheckBoxGroup')" />
                        <label for="TopCheckBox" class="tn-check-all">
                            <%=GetResourceString("Label_SelectAllOrNo") %></label>
                        <%=SPBHtmlHelper.Instance().LinkButton("buttonApprove", GetResourceString("Button_Approve"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setBlogStatue('approve')" } }, null)%>
                        <%=SPBHtmlHelper.Instance().LinkButton("buttonNoApprove", GetResourceString("Button_NoApprove"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setBlogStatue('noApprove')" } }, null)%>
                        <%=SPBHtmlHelper.Instance().LinkButton("actionDelete", GetResourceString("Action_Delete"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "setBlogStatue('delete')" } }, null)%>
                        <% if (ViewData["approvalStatus"] == null)
                           {%>
                        <%=SPBHtmlHelper.Instance().ApproveStatusDropDownList("approveDropDownList", null, "tn-dropdownlist", "GetCommentsByApproveStatus()")%>
                        <%}
                           else
                           {%>
                        <%=SPBHtmlHelper.Instance().ApproveStatusDropDownList("approveDropDownList", (ApprovalStatuses)ViewData["approvalStatus"], "tn-dropdownlist", "GetCommentsByApproveStatus()")%>
                        <%} %>
                        <div class="tn-blank10">
                        </div>
                    </div>
                </div>
            </div>
            <div class="tn-grid">
                <%  
                    if (TempData["StatusMessageType"] != null)
                    {
                        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);

                        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));

                        TempData["StatusMessageType"] = null;
                    }   
                %>
                <table class="tn-table-grid">
                    <tr class="tn-table-grid-header">
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_Body")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_IfApproval")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_CommentUser")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_PostSubject")%>
                        </th>
                        <th class="tn-border-gray tn-border-bottom tn-text-note">
                            <%=GetResourceString("Label_CommentDate") %>
                        </th>
                    </tr>
                    <% if (blogComments != null && blogComments.Records.Count > 0)
                       {
                           foreach (BlogComment blogComment in blogComments.Records)
                           {
                               if (blogComment != null)
                               {%>
                    <tr class="tn-table-grid-row">
                        <td class="tn-border-gray tn-border-bottom tn-width-check">
                            <input type="checkbox" name="BlogCommentCheckBoxGroup" value="<%=blogComment.PostID.ToString() %>" />
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-auto">
                            <a href="<%=SPBUrlHelper.Action("ShowBlogThread","Blog",new RouteValueDictionary{{"threadID",blogComment.ThreadID},{"userDomainName",userDomainName}}) %>#<%=blogComment.PostID %>"
                                title="<%=HtmlUtils.StripForPreview(blogComment.Body) %>">
                                <%=HtmlUtils.TrimHtml(blogComment.Body,30) %>
                            </a>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                            <% if (blogComment.IsApproved)
                               { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept, GetResourceString("Description_CommentAuditinged"))); }
                               else
                               { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross, GetResourceString("Description_CommentNotAuditing"))); }%>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                            <% if (string.IsNullOrEmpty(blogComment.TitleUrl)) Response.Write(blogComment.Author);
                               else
                               {%>
                            <a href="<%=blogComment.TitleUrl %>">
                                <%=blogComment.Author%></a>
                            <%} %>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-nowrap">
                            <a href="<%=SPBUrlHelper.Action("ShowBlogThread","Blog",new RouteValueDictionary{{"threadID",blogComment.ThreadID},{"userDomainName",userDomainName}}) %>"
                                title="<%=StringUtils.Trim(blogComment.Subject,500)%>">
                                <%=StringUtils.Trim(blogComment.Subject,18)%></a>
                        </td>
                        <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                            <%=Formatter.FormatDate(blogComment.PostDate,true) %>
                        </td>
                    </tr>
                    <%}
                           }
                       } %>
                </table>
            </div>
            <div class="tn-pagination tn-helper-align-center">
                <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, blogComments.TotalRecords, blogComments.PageSize, blogComments.PageIndex, 7, SPBUrlHelper.Action("ManageBlogComments", "Blog", new RouteValueDictionary {{ "userDomainName", userDomainName },{"approvalStatus",nowApprovalStatus},{"pageIndex","{0}"}}))%>
            </div>
            </form>
        </div>
    </div>
</div>
<script type="text/javascript">
    function setBlogStatue(action) {
        if ($("input[name='BlogCommentCheckBoxGroup']:checked").length <= 0) {
            alert("至少选择一条评论！");
            return false;
        }
        if (action == 'approve')
            $('#ManageBlogCommentsForm').ajaxSubmit({ target: '#ManageBlogCommentsDiv', url: '<%=SPBUrlHelper.Action("SetBlogCommentsApproveStatus","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"isApproved",true}}) %>' });
        else if (action == 'noApprove')
            $('#ManageBlogCommentsForm').ajaxSubmit({ target: '#ManageBlogCommentsDiv', url: '<%=SPBUrlHelper.Action("SetBlogCommentsApproveStatus","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"isApproved",false}}) %>' });
        else if (action == 'delete') {
            if (!confirm('<%=GetResourceString("Message_ConfirmDeleteBlogComments",BlogApplicationID) %>'))
                return;
            $('#ManageBlogCommentsForm').ajaxSubmit({ target: '#ManageBlogCommentsDiv', url: '<%=SPBUrlHelper.Action("DeleteBlogComments", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>', type: 'post' });
        }
    }

    function GetCommentsByApproveStatus() {
        $('#ManageBlogCommentsForm').ajaxSubmit({ target: '#ManageBlogCommentsDiv', url: '<%=SPBUrlHelper.Action("ManageBlogCommentsByApprovalStatus","Blog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>' });
    }
  
    
</script>
