﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogThread>>" %>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<%int BlogApplicationID = ApplicationIDs.Instance().Blog();
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");

  RouteValueDictionary dictionary = new RouteValueDictionary { { "userDomainName", userDomainName } };
  bool hasPermission = ViewData.GetBool("hasPermission", false);
%>
<div id="ManageBlogThreadsDiv">
    <%   if (TempData["StatusMessageType"] != null)
         {
             StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
             if (messageType == StatusMessageType.Success)
             {
                 //关闭模式窗口
                 Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000);</script>"));
                 TempData["StatusMessageType"] = null;
             }
         } %>
    <div id="maageBlogThreads" class="tn-box tn-widget tn-widget-content tn-corner-all spb-manage-blogs">
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <form id="manageBlogThreadsForm" name="manageBlogThreadsForm" method="post">
            <div class="tn-list-header">
                <% if (hasPermission)
                   {
                       ICollection<UserTag> userTags = ViewData.Get<ICollection<UserTag>>("userTags", null);
                       List<UserCategory> userCategoryList = ViewData.Get<List<UserCategory>>("userCategoryList", new List<UserCategory>());
                       List<SiteCategory> allSiteCategoryList = ViewData.Get<List<SiteCategory>>("allSiteCategoryList", new List<SiteCategory>());
                %>
                <div class="tn-toolbar tn-helper-clearfix">
                    <div class="tn-tool-form">
                        <input id="checkAllOrNo" class="tn-checkbox" type="checkbox" id="TopCheckBox" onclick="checkAll(this,'ThreadCheckBoxGroup')" />
                        <label for="checkAllOrNo" class="tn-check-all">
                            <%=GetResourceString("Label_SelectAllOrNo") %></label>
                        <%=SPBHtmlHelper.Instance().LinkButton("deleteButton", GetResourceString("Button_BatchDelete"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "deleteBlogThreads()" } }, null)%>
                        <%=SPBHtmlHelper.Instance().Button("permissionSettings", GetResourceString("Title_PermissionsSettings"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#privacyControl" } })%>
                        <div id="privacyControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                            <ul>
                                <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="if(!VerifyChoose()) return false; $('#manageBlogThreadsForm').ajaxSubmit({ target: '#ManageBlogThreadsDiv', url: '<%=SPBUrlHelper.Action("SetBlogThreadsPrivacyStatus","Blog",new RouteValueDictionary(dictionary){{ "stause",PrivacyStatuses.Public },{"pageIndex",Model.PageIndex}}) %>' });">
                                    <%=GetResourceString("Enum_PrivacyStatuses_Public") %></a></li>
                                <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="if(!VerifyChoose()) return false; $('#manageBlogThreadsForm').ajaxSubmit({ target: '#ManageBlogThreadsDiv', url: '<%=SPBUrlHelper.Action("SetBlogThreadsPrivacyStatus","Blog",new RouteValueDictionary(dictionary){{ "stause",PrivacyStatuses.OnlyFriend },{"pageIndex",Model.PageIndex}}) %>' });">
                                    <%=GetResourceString("Enum_PrivacyStatuses_OnlyFriend") %></a></li>
                                <li class="tn-menu-item"><a id="editPassWord" class="tn-menu-text" href="javascript:;">
                                    <%=GetResourceString("Enum_PrivacyStatuses_NeedPassword") %></a></li>
                                <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="if(!VerifyChoose()) return false; $('#manageBlogThreadsForm').ajaxSubmit({ target: '#ManageBlogThreadsDiv', url: '<%=SPBUrlHelper.Action("SetBlogThreadsPrivacyStatus","Blog",new RouteValueDictionary(dictionary){{ "stause",PrivacyStatuses.Privacy },{"pageIndex",Model.PageIndex}}) %>' });">
                                    <%=GetResourceString("Enum_PrivacyStatuses_Privacy")%></a></li>
                            </ul>
                        </div>
                        <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Title_StickTags"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#userTagControl" } })%>
                        <%if (userTags != null && userTags.Count > 0)
                          { %>
                        <div id="userTagControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                            <ul class="tn-menu-list">
                                <%foreach (UserTag tag in userTags)
                                  {%>
                                <li class="tn-menu-item">
                                    <input class="tn-checkbox" name="setUserTags" id="setUserTags<%=tag.TagName%>" type="checkbox"
                                        value="<%=tag.TagName%>" />
                                    <label for="setUserTags<%=tag.TagName%>">
                                        <%=tag.TagName %></label>
                                </li>
                                <%} %>
                            </ul>
                            <div class="tn-menu-add tn-border-light tn-border-top">
                                <a class="tn-helper-right" href="javascript:;" onclick="if(!VerifyChoose()) return false; stickTags()">
                                    <%=GetResourceString("Button_Save")%></a> <a class="editUserTag" href="javascript:;">
                                        <%=GetResourceString("Action_CreatTag")%></a></div>
                            <script type="text/javascript">
                                function stickTags() {
                                    var usertags = "";
                                    $("input[type='checkbox'][name='setUserTags']").each(function (index, e) {
                                        if (e.checked) {
                                            if (usertags == "") {
                                                usertags = e.value;
                                            } else {
                                                usertags = usertags + "," + e.value;
                                            }
                                        }
                                    });
                                    $('#manageBlogThreadsForm').ajaxSubmit({ data: { setUserTagss: usertags }, target: '#ManageBlogThreadsDiv', url: '<%=SPBUrlHelper.Action("SetBlogThreadsTags","Blog",new RouteValueDictionary(dictionary){}) %>' });
                                };
                            </script>
                        </div>
                    <%} %>
                    <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Title_ToMyUserCategory"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#userCategoryControl" } })%>
                    <%if (userCategoryList != null && userCategoryList.Count > 0)
                      { %>
                    <div id="userCategoryControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                        <ul class="tn-menu-list">
                            <%foreach (UserCategory category in userCategoryList)
                              {
                            %>
                            <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="if(!VerifyChoose()) return false; $('#manageBlogThreadsForm').ajaxSubmit({ target: '#ManageBlogThreadsDiv', url: '<%=SPBUrlHelper.Action("SetBlogThreadsUserCategory","Blog",new RouteValueDictionary(dictionary){{"userCategoryID",category.CategoryID},{"pageIndex",Model.PageIndex}}) %>' });">
                                <%=category.CategoryName%></a></li>
                            <%} %>
                        </ul>
                    </div>
                    <%} %>
                    <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Title_ReturnToSiteCategory"), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#siteCategoryControl" } })%>
                    <%if (allSiteCategoryList != null && allSiteCategoryList.Count > 0)
                      { %>
                    <div id="siteCategoryControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                        <ul class="tn-menu-list">
                            <%foreach (SiteCategory siteCategory in allSiteCategoryList)
                              {%>
                            <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="if(!VerifyChoose()) return false; $('#manageBlogThreadsForm').ajaxSubmit({ target: '#ManageBlogThreadsDiv', url: '<%=SPBUrlHelper.Action("SetBlogThreadsSiteCategory","Blog",new RouteValueDictionary(dictionary){{"siteCategoryID",siteCategory.CategoryID},{"pageIndex",Model.PageIndex}}) %>' });">
                                <%string blankSpace = string.Empty; %>
                                <% 
                                    for (int i = 0; i < siteCategory.Depth; i++)
                                    {
                                        blankSpace = blankSpace + "　";
                                    }
                                    Response.Write(blankSpace);
                                %>
                                <%=siteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%>
                            </a></li>
                            <%} %>
                        </ul>
                    </div>
                    <%} %>
                    </div>
                </div>
                <%} %>
            </div>
            <div id="loading" style="display: none" class=" tn-loading">
            </div>
            <table class="tn-table-grid">
                <tr class="tn-table-grid-header">
                    <% if (hasPermission)
                       {%>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                    </th>
                    <%} %>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_Subject")%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%= GetResourceString("Common_Category") %>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_SiteDivisionCategory")%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_Privacy", BlogApplicationID)%>
                    </th>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_PostDate")%>
                    </th>
                    <% if (hasPermission)
                       {%>
                    <th class="tn-border-gray tn-border-bottom tn-text-note">
                        <%=GetResourceString("Label_Actions")%>
                    </th>
                    <%} %>
                </tr>
                <% if (Model != null && Model.Records.Count > 0)
                   {
                       foreach (BlogThread blogThread in Model.Records)
                       {
                           if (blogThread == null)
                               continue;
                %>
                <tr class="tn-table-grid-row">
                    <% if (hasPermission)
                       {%>
                    <td class="tn-border-gray tn-border-bottom tn-width-check">
                        <input type="checkbox" name="ThreadCheckBoxGroup" class="tn-checkbox thrdadsCheckBoxIDs"
                            value="<%=blogThread.ThreadID.ToString() %>" />
                    </td>
                    <%} %>
                    <td class="tn-border-gray tn-border-bottom">
                        <a href="<%=SiteUrls.Instance().ShowBlogThread(userDomainName,blogThread) %>" title="<%=blogThread.Subject %>">
                            <%=StringUtils.Trim(blogThread.Subject,18) %></a>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <%if (blogThread.UserCategory != null)
                          {%>
                        <a href="<%=SPBUrlHelper.Action("ListBlogThreadsByUserCategory","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"categoryID",blogThread.UserCategory.CategoryID}}) %>">
                            <%=StringUtils.Trim(blogThread.UserCategory.CategoryName,5)%></a>
                        <%} %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <% if (blogThread.SiteCategory != null)
                           {%>
                        <a href="<%=SPBUrlHelper.Action("ListBlogThreadsByCategory","ChannelBlog",new RouteValueDictionary{{"categoryID",blogThread.SiteCategory.CategoryID}}) %>">
                            <%=blogThread.SiteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%></a>
                        <%} %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-width-icon1 tn-nowrap">
                        <%switch (blogThread.PrivacyStatus)
                          {
                              case PrivacyStatuses.NeedPassword:
                        %>
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword"))%>
                        <%
                            break;
                              case PrivacyStatuses.OnlyFriend:
                        %>
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Limit, GetResourceString("Enum_PrivacyStatuses_OnlyFriend"))%>
                        <%
                            break;
                              case PrivacyStatuses.Privacy:
                        %>
                        <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy"))%>
                        <%
                            break;
                              case PrivacyStatuses.Public:
                            break;
                              default:
                            break;
                          } %>
                    </td>
                    <td class="tn-border-gray tn-border-bottom tn-nowrap">
                        <a href="<%=SPBUrlHelper.Action("ListBlogThreadsByYMD","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"year",blogThread.PostDate.Year},{"month",blogThread.PostDate.Month},{"day",blogThread.PostDate.Day}}) %>">
                            <%=Formatter.FormatDate(blogThread.PostDate,false) %></a>
                    </td>
                    <% if (hasPermission)
                       {%>
                    <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                        <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("EditBlogThread","Blog",new RouteValueDictionary{{"ThreadID",blogThread.ThreadID},{"userDomainName",WebUtils.UrlEncode(userDomainName)}}) %>">
                            <%=GetResourceString("Action_Edit")%></a></span><span class="tn-action"><a class="tn-action-text"
                                onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteArticle", BlogApplicationID) %>')) { $('#ManageBlogThreadsDiv').load('<%=SPBUrlHelper.Action("DeleteBlogThread","Blog",new RouteValueDictionary(dictionary){{"ThreadID",blogThread.ThreadID},{"pageIndex",Model.PageIndex },{"isManage",true}}) %>' )}"
                                href="javascript:;;">
                                <%=GetResourceString("Action_Delete")%></a></span>
                    </td>
                    <%} %>
                </tr>
                <%}
                   } %>
            </table>
            <div class="tn-pagination tn-helper-align-center">
                <% if (Model != null)
                   {%>
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ManageBlogThreads", "Blog", new RouteValueDictionary(dictionary) {{ "pageIndex", "{0}" } }), "listBlogThreadPageIndexChange")%>
                <%} %>
            </div>
            </form>
        </div>
    </div>
    <script type="text/javascript">
     $(document).ready(function() {
             
     $('.editUserTag').click(function(e) {
                    e.preventDefault();
                    $.nyroModalManual({
                        modal: false,
                        width: 300,
                        height: 200,
                        url: '<%=SPBUrlHelper.Action("Control_EditUserTag", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userTagItemKey", UserTagItemKeys.Instance().BlogThread() } }) %>',
                        endRemove: function() { $('#ManageBlogThreadsDiv').load('<%=SPBUrlHelper.Action("Control_ManageBlogThreads","Blog",new RouteValueDictionary(dictionary){{"pageIndex",Model.PageIndex}}) %>'); }

                    });
                    return false;
                });
     
      $('#editPassWord').click(function(e) {
                 if (!VerifyChoose())
                    return false;
                    e.preventDefault();
                    $.nyroModalManual({
                        modal: false,
                        width: 300,
                        height: 200,
                        url: '<%=SPBUrlHelper.Action("Control_EditPassWord", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName }}) %>',
                        endRemove: function() { $('#ManageBlogThreadsDiv').load('<%=SPBUrlHelper.Action("Control_ManageBlogThreads","Blog",new RouteValueDictionary(dictionary){{"pageIndex",Model.PageIndex}}) %>'); }
                    });
                    return false;
                });
		$("div.tn-list-header span[menu]").menuButton({ clickTrigger: true, notTriggerClose: ".tn-menu-list,.tn-menu input" });

});
        function deleteBlogThreads() {
         if (!VerifyChoose())
                                        return false;
         if(confirm('<%=GetResourceString("Message_ConfirmDeleteArticels",BlogApplicationID) %>'))
                $('#manageBlogThreadsForm').ajaxSubmit({ target: '#ManageBlogThreadsDiv', url: '<%=SPBUrlHelper.Action("DeleteBlogThreads","Blog",new RouteValueDictionary(dictionary){{"pageIndex",Model.PageIndex}}) %>' });
        };
         function VerifyChoose() {
                            if ($("input[name='ThreadCheckBoxGroup']:checked").length <= 0) {
                                alert("至少选择一篇文章！");
                                return false;
                            }
                            return true;
                        }
        
    </script>
</div>
