﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    BlogSection section = ViewData.Get<BlogSection>("BlogSection");
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int threadID = Html.GetParameterFromRouteDateOrQueryString<int>("threadID");
    int pageIndex = Html.GetParameterFromRouteDateOrQueryString<int>("pageIndex");
    int parentID = Html.GetParameterFromRouteDateOrQueryString<int>("parentID");
    bool isReplay = Html.GetParameterFromRouteDateOrQueryString<bool>("isReplay");
    if (pageIndex < 1)
        pageIndex = 1;
    bool userCookieRemember = true;
    string rememberMyName = ViewData.GetString("rememberMyName", string.Empty);
    if (string.IsNullOrEmpty(rememberMyName))
    {
        rememberMyName = GetResourceString("Common_AnonymousDisplayName");
        userCookieRemember = false;
    }
    string rememberMyUrl = ViewData.GetString("rememberMyUrl", string.Empty);
%>
<%  if (CurrentUser == null && (!SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting || !section.EnableAnonymousPosting))
    {
        Response.Write(string.Format(GetResourceString("Message_Pattern_AnonymousCreateCommentHint"), SiteUrls.Instance().Login(true), SiteUrls.Instance().UserRegister()));
    }
    else
    { %>
<div class="tn-blank10">
</div>
<form id="CommentForm_<%if (isReplay) Response.Write(parentID); else Response.Write(0); %>"
class="tn-helper-reset" action="<%=SPBUrlHelper.Action("CreateBlogThreadComment","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"threadID",threadID},{"pageIndex",pageIndex},{"parentID",parentID},{"isReplay",isReplay}}) %>"
method="post">
<div class="tn-form tn-label-top">
    <div class="tn-comment-form-wrap tn-bg-gray">
        <div class="tn-comment-form">
            <a name="Comment" id="Comment"></a>
            <div class="tn-comment-form tn-emotion-box">
                <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector(parentID.ToString(), "commentBody_" + parentID));%>
                <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near tn-textarea-wrap">
                    <textarea name="commentBody" id="commentBody_<%=parentID %>" cols="60" rows="5" class="tn-comment-text-area"><%=TempData.GetString("commentBody", string.Empty)%></textarea>
                    <span style="display:none"></span>
                </div>
                <div class="tn-form-row tn-text-note">
                    <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit"), UserDomainConfiguration.Instance().MaxLengthPerReply)%>
                </div>
            </div>
        </div>
        <% if (CurrentUser == null)
           {%>
        <div class="tn-form-row">
            <label class="tn-form-label">
                <%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="Author"
                value="<%=rememberMyName %>" id="Author" maxlength="30" />
            <em>(<%=GetResourceString("Common_GuestDisplayName")%>)</em>
            <input type="checkbox" <% if (userCookieRemember) Response.Write("checked=\"checked\""); %>
                id="RememberMe" value="1" name="RememberMe" />
            <label for="RememberMe">
                <%=GetResourceString("Description_MemoryMyInfo")%></label>
        </div>
        <div class="tn-form-row">
            <label class="tn-form-label">
                <%=GetResourceString("Label_PersonalWebAdress")%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" maxlength="200" class="tn-textbox tn-input-long tn-border-gray"
                value="<%=rememberMyUrl %>" name="CommenterUrl" />
        </div>
        <%} %>
        <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
          if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
          {%>
        <div class="tn-form-row tn-form-row-verifycode">
            <label>
                <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon")%></label>
            <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%>
        </div>
        <%} %>
        <div class="tn-form-row tn-form-row-button">
            <%=SPBHtmlHelper.Instance().SubmitButton("createBlogComment_"+parentID, GetResourceString("Button_Submit"))%>
            <% if (parentID > 0 && TempData["commentBody"] == null)
               { %>
            <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Large, new RouteValueDictionary { { "onclick", "$(\"#CommentForm_"+parentID+"\").hide()" } })%>
            <%} %>
        </div>
    </div>
</div>
</form>
<script type="text/javascript">
    $(document).ready(function () {
        var $form = $("#CommentForm_<%=parentID %>");
        $form.validate({
            rules: {
                commentBody: { required: true, maxBlength:'<%=UserDomainConfiguration.Instance().MaxLengthPerReply %>' },
                verifyCode: { required: true }
            },
            messages: {
                commentBody: { required: '<%=GetResourceString("Validate_FillInCommentBody") %>', rangelength: '<%=string.Format(GetResourceString("Validate_Pattern_CommentBodyMaxLength"), UserDomainConfiguration.Instance().MaxLengthPerReply)%>' },
                verifyCode: { required: '<%=GetResourceString("Validate_FillInValidate") %>' }
            }
        });

        $("#createBlogComment_<%=parentID %>").click(function () {
            if (!$form.valid()) {
                return false;
            }
        });
        $form.ajaxForm({
            beforeSubmit: function () {
                if (!$form.valid())
                { return false; }
                $form.block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            success: function (data) {
                $("#createBlogComment_<%=parentID %>").show().next('button:last').hide();
                $form.unblock();
                $("#BlogThreadComments").parent().html(data);
            }
        });
        $('.nyroModal').nyroModal({
            resizeable: true
        });
    });
</script>
<%} %>