﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<BlogComment>>" %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-new-blog-comments">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_NewComment")%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <%IList<BlogComment> blogComments = Model;
          if (blogComments != null && blogComments.Count > 0)
          {%>
        <ul class="tn-list">
            <%foreach (BlogComment blogComment in blogComments)
              {%>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <h5 class="tn-helper-reset">
                    <a href="<%=SPBUrlHelper.Action("ShowBlogThread","Blog",new RouteValueDictionary{{"threadID",blogComment.ThreadID},{"userDomainName",Html.GetParameterFromRouteDateOrQueryString("userDomainName")}}) %>#<%=blogComment.PostID %>">
                        <%=StringUtils.Trim(blogComment.Subject,29) %></a>
                </h5>
                <p>
                    <%=HtmlUtils.TrimHtml(blogComment.Body,28) %></p>
                <cite>
                    <% if (blogComment.UserID > 0)
                       {%>
                    <a class="tn-author" href="<%=SiteUrls.Instance().UserChannelHome(blogComment.UserID, ApplicationIDs.Instance().Blog()) %>">
                        <%=StringUtils.Trim(blogComment.Author, 5)  %></a>
                    <%}
                       else
                       {
                           if (string.IsNullOrEmpty(blogComment.TitleUrl))
                           { %>
                    <a class="tn-author" href="<%=blogComment.TitleUrl %>">
                        <%=StringUtils.Trim(blogComment.Author, 5) %></a>
                    <%}
                                   else
                                       Response.Write(StringUtils.Trim(blogComment.Author, 5)); %>
                    <% } %>
                </cite>&nbsp;<em class="tn-date tn-text-note">
                    <%=Formatter.FormatDate(blogComment.PostDate,true) %></em> </li>
            <%} %>
        </ul>
        <%} %>
    </div>
</div>
