﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int threadID = Html.GetParameterFromRouteDateOrQueryString<int>("threadID");
    if (TempData["statusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.dialog.closeAll();refresh();',2000)</script>"));
        }
        TempData["statusMessageData"] = null;
    }
%>
<form id="passwordForm" class="artDialog" method="post" action="<%=SPBUrlHelper.Action("AuthorizePrivacyPassword", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName }, { "threadID", threadID }})%>">
<div class="tn-form tn-label-right">
    <div class="tn-form-row">
        <label class="tn-form-label">
            密码：</label>
        <input type="password" class="tn-textbox tn-input-medium tn-border-gray" name="password"
            id="password" />
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("passwordSubmitButton", GetResourceString("Button_OK"), ButtonSizes.Default,null, null)%>
        <%=SPBHtmlHelper.Instance().CloseButton(ButtonSizes.Default, new RouteValueDictionary { { "class", "dialogClose" } })%>
    </div>
</div>
</form>
<script type="text/javascript">
    $(document).ready(function () {
        $("#passwordForm").validate({
            rules: {
                password: { required: true }
            },
            messages: {
                password: { required: "*" }
            }
        });

        $("#passwordSubmitButton").click(function () {
            if (!$("#passwordForm").valid()) {
                return false;
            }
        });

    });
                    
</script>
