﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogThread>>" %>
<spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<%int BlogApplicationID = ApplicationIDs.Instance().Blog();
  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
  int? categoryID = null;
  if (Html.GetParameterFromRouteDateOrQueryString<int>("categoryID") > 0)
      categoryID = Html.GetParameterFromRouteDateOrQueryString<int>("categoryID");
  string tagName = Html.GetParameterFromRouteDateOrQueryString("tagName");
  bool isSummary = Html.GetParameterFromRouteDateOrQueryString<bool>("isSummary");
  int? year = null; int? month = null; int? day = null;
  if (Html.GetParameterFromRouteDateOrQueryString<int>("year") > 0)
      year = Html.GetParameterFromRouteDateOrQueryString<int>("year");
  if (Html.GetParameterFromRouteDateOrQueryString<int>("month") > 0)
      month = Html.GetParameterFromRouteDateOrQueryString<int>("month");
  if (Html.GetParameterFromRouteDateOrQueryString<int>("day") > 0)
      day = Html.GetParameterFromRouteDateOrQueryString<int>("day");
  string boxTitle = ViewData.GetString("boxTitle", string.Empty);

  RouteValueDictionary dictionary = new RouteValueDictionary { { "userDomainName", userDomainName }, { "categoryID", categoryID }, { "tagName", tagName }, { "year", year }, { "month", month }, { "day", day } };
  bool hasPermission = ViewData.GetBool("hasPermission", false);
  bool isFriend = ViewData.GetBool("isFriend", false);
%>
<div id="summaryBlogThreadsDiv">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <%if (!string.IsNullOrEmpty(boxTitle))
          {%>
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset">
                <%=boxTitle%></h3>
        </div>
        <%} %>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <div class="tn-list-header">
                <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <span class="tn-text-note tn-helper-left">
                        <%=string.Format(GetResourceString("Description_Pattern_AllArticle", BlogApplicationID), (Model == null ? 0 : Model.TotalRecords))%>
                    </span><span class="tn-helper-right">
                        <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %>
                        <span class="tn-action tn-action-text-icon tn-text-note tn-selected">
                            <%=SPBHtmlHelper.Instance().Icon(IconTypes.BrowseDetail) %>
                            <a href="javascript:;" class="tn-action-text">
                                <%=GetResourceString("Action_Summary")%></a></span> <span class="tn-action tn-action-text-icon">
                                    <%=SPBHtmlHelper.Instance().Icon(IconTypes.BrowseList) %><a href="javascript:;" class="tn-action-text"
                                        id="actionList">
                                        <%=GetResourceString("Action_List")%></a></span></span>
                </div>
            </div>
            <div id="loading" style="display: none" class="tn-loading">
            </div>
            <ul class="tn-list tn-helper-reset" id="summaryBlogThreads">
                <% 
                    if (Model != null && Model.Records.Count > 0)
                    {%>
                <%foreach (BlogThread blogThread in Model.Records)
                  {
                      if (blogThread == null || blogThread.ThreadID <= 0)
                          continue;
                %>
                <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom" id="blogitem_<%=blogThread.ThreadID %>">
                    <% if (blogThread.HasUserFeaturedImage)
                       {%>
                    <div class="tn-list-item-area-left">
                        <img src="<%=SiteUrls.Instance().BlogPhotoUrl(blogThread.UserFeaturedImageAttachmentID, BlogPhotoTypes.Title) %>" />
                    </div>
                    <%} %>
                    <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row tn-list-item-heading">
                            <h5 class="tn-helper-reset">
                                <a href="<%=SiteUrls.Instance().ShowBlogThread(userDomainName,blogThread) %>" title="<%=blogThread.Subject %>">
                                    <%=StringUtils.Trim(blogThread.Subject, 30)%></a>
                                <% if (blogThread.SpecialOrder > 0)
                                   {%>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                                <%}
                                   if (blogThread.IsEssential)
                                   {%>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Elite,GetResourceString("Common_Essential"),new RouteValueDictionary{{"class","tn-icon-inline"}})%>
                                <%}
                                   switch (blogThread.PrivacyStatus)
                                   {
                                       case PrivacyStatuses.NeedPassword:
                                %>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Key, GetResourceString("Enum_PrivacyStatuses_NeedPassword"), new RouteValueDictionary {{"class","tn-icon-inline"} })%>
                                <%
                                    break;
                                       case PrivacyStatuses.OnlyFriend:
                                %>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Limit, GetResourceString("Enum_PrivacyStatuses_OnlyFriend"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                                <%
                                    break;
                                       case PrivacyStatuses.Privacy:
                                %>
                                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Enum_PrivacyStatuses_Privacy"), new RouteValueDictionary {{"class","tn-icon-inline"} })%>
                                <%
                                    break;
                                       case PrivacyStatuses.Public:
                                %>
                                <%
                                    break;
                                       default:
                                    break;
                                   } %>
                            </h5>
                        </div>
                        <div class="tn-list-item-row tn-list-item-summary">
                            <p class="tn-helper-reset">
                                <% if (hasPermission || blogThread.PrivacyStatus == PrivacyStatuses.Public)
                                   {%>
                                <%=HtmlUtils.TrimHtml (blogThread.GetBody(false),55)%>
                                <%}
                                   else
                                   {
                                       switch (blogThread.PrivacyStatus)
                                       {
                                           case PrivacyStatuses.NeedPassword:
                                %>
                                <%=GetResourceString("Description_PasswordRead", BlogApplicationID)%>
                                <a href="javascript:;" onclick="$('#passwordSpan<%=blogThread.ThreadID %>').attr('style','display:block');">
                                    <%=GetResourceString("Common_HavePassword")%></a> <span id="passwordSpan<%=blogThread.ThreadID %>"
                                        style="display: none">
                                        <%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon") %>
                                        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="passwordInput<%=blogThread.ThreadID %>" />
                                        <%=SPBHtmlHelper.Instance().LinkButton("buttonOK", GetResourceString("Button_OK"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "showBlogThread()" } },null)%>
                                        <%=SPBHtmlHelper.Instance().LinkButton("buttonCancel", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "onclick", "cancelReadBlog()" } },null)%>
                                    </span>
                                <script type="text/javascript">

                                    function showBlogThread() {
                                        window.location = '<%=SPBUrlHelper.Action("ShowBlogThread","Blog",new RouteValueDictionary{{"threadID",blogThread.ThreadID},{"userDomainName",userDomainName}}) %>' + '?password=' + $('#passwordInput<%=blogThread.ThreadID %>').val();
                                    }
                                    function cancelReadBlog() {
                                        $('#passwordSpan<%=blogThread.ThreadID %>').attr('style', 'display:none');
                                    }
                                </script>
                                <%
break;
                                           case PrivacyStatuses.OnlyFriend:
                                %>
                                <% if (isFriend)
                                   { %>
                                <%=StringUtils.Trim(blogThread.ForcedExcerpt, 150)%>
                                <%}
                                   else
                                   { %>
                                <%=GetResourceString("Description_ArticleOnlyFriendRead", BlogApplicationID)%>
                                <%if (CurrentUser != null)
                                  { %>
                                <a class="makeFriendForAuthority" href="<%=SiteUrls.Instance().NewFriendInvitation(Globals.GetCurrentUser().UserName, UserID2UserNameDictionary.GetUserID(userDomainName))%>">
                                    <%=GetResourceString("Action_IntercourseFriend")%></a>
                                <%} %>
                                <%} %>
                                <%
break;
                                           case PrivacyStatuses.Privacy:
break;
                                           case PrivacyStatuses.Public:
break;
                                           default:
break;
                                       }%>
                                <%} %>
                            </p>
                        </div>
                        <div class="tn-list-item-row">
                            <cite><a href="<%=SiteUrls.Instance().UserChannelHome(blogThread.OwnerUserID, ApplicationIDs.Instance().Blog()) %>"
                                class="tn-author">
                                <%=blogThread.Author%></a></cite> <em class="tn-date tn-text-note"><a href="<%=SPBUrlHelper.Action("ListBlogThreadsByYMD","Blog",new RouteValueDictionary{{"userDomainName",userDomainName},{"year",blogThread.PostDate.Year},{"month",blogThread.PostDate.Month},{"day",blogThread.PostDate.Day}}) %>">
                                    <%=Formatter.FormatDate(blogThread.PostDate,true) %></a></em> <cite class="tn-text-note">
                                        <%=SPBHtmlHelper.Instance().ShowRating(blogThread.RatingSum,blogThread.TotalRatings) %>
                                    </cite>
                            <% string title = string.Empty;
                               if (!blogThread.IsLocked)
                                   title = GetResourceString("Common_Comment") + " (" + blogThread.CommentCount + ")";
                               else
                                   title = GetResourceString("Label_CloseComment", BlogApplicationID);
                            %>
                            <%=SPBHtmlHelper.Instance().LinkButton("comment", title, SiteUrls.Instance().ShowBlogThread(userDomainName, blogThread) + "#Comment", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%>
                            <%=SPBHtmlHelper.Instance().LinkButton("browser", GetResourceString("Common_Browse") + " (" + blogThread.HitTimes+")", SiteUrls.Instance().ShowBlogThread(userDomainName, blogThread), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%>
                            <%if (hasPermission)
                              { %>
                            <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("EditBlogThread","Blog",new RouteValueDictionary{{"ThreadID",blogThread.ThreadID},{"userDomainName",WebUtils.UrlEncode(userDomainName)}}) %>">
                                <%=GetResourceString("Action_Edit")%></a></span> <span class="tn-action"><a class="tn-action-text"
                                    onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteArticle", BlogApplicationID) %>')) { $('#summaryBlogThreadsDiv').parent().load('<%=SPBUrlHelper.Action("DeleteBlogThread","Blog",new RouteValueDictionary(dictionary){{ "isSummary", isSummary },{"ThreadID",blogThread.ThreadID},{"pageIndex",Model.PageIndex },{"isManage",false}}) %>' )}"
                                    href="javascript:;;">
                                    <%=GetResourceString("Action_Delete")%></a></span>
                            <%} %>
                        </div>
                    </div>
                </li>
                <%}
                    } %>
            </ul>
            <div class="tn-pagination tn-helper-align-center">
                <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListBlogThreads", "Blog", new RouteValueDictionary(dictionary) { { "isSummary", isSummary }, { "pageIndex", "{0}" } }), "summaryBlogThreadPageIndexChange")%>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {
          
            $("#actionList").click(function() {
                showLoading();
                $("#summaryBlogThreadsDiv").parent().load("<%=SPBUrlHelper.Action("Control_ListBlogThreads","Blog", new RouteValueDictionary(dictionary){{"isSummary",false}}) %>");
            });


            $("a[class='makeFriendForAuthority']").nyroModal({
                resizeable: true
            });
                      $("a[menu]").menuButton();    
            
        });
        function showLoading(){
                $("#loading").show();        
                $("div.tn-pagination").hide();
                $("#summaryBlogThreads").hide();
        }
        function summaryBlogThreadPageIndexChange(url) {
            showLoading();
            $('#summaryBlogThreadsDiv').parent().load(url);
        }

    </script>
</div>
