﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<ClubActivity>>" %>
<% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
   int applicationID = ApplicationIDs.Instance().Club();%>
<div id="ListClubActivitiesBlock" class="tn-box tn-widget tn-widget-content tn-corner-all spb-friends-news">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ListReceivedClubActivities","MessageCenter",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
            <%=GetResourceString("Action_More")%></a> </span>
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_ClubDynamic",applicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <% if (Model.Count > 0)
           {%>
        <ul class="tn-list tn-helper-reset">
            <%foreach (ClubActivity clubActivity in Model)
              {
                  if (clubActivity.Club == null)
                      continue;
            %>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-area-left">
                    <div class="tn-avatar">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(clubActivity.LeadingActorUserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%>
                    </div>
                </div>
                <div class="tn-list-item-row">
                    <%=clubActivity.Subject%>
                </div>
            </li>
            <%}%>
        </ul>
        <%} %>
    </div>
</div>
