﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<SpaceBuilder.Club.Club>>" %>
<% int applicationID = ApplicationIDs.Instance().Club();
   bool isManger = ViewData.GetBool("isManger", false);
   bool isCreater = Html.GetParameterFromRouteDateOrQueryString<bool>("isCreater");
   string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all" id="ListMyClubsDiv">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom tn-helper-align-right">
                查看：
                <span class="tn-action <%if(!isCreater) Response.Write("tn-selected"); %>">
                    <a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListMyClubs", "ClubUserDomain", new RouteValueDictionary { { "userDomainName", userDomainName },{"isCreater",false
                    } })%>">
                        <%=GetResourceString("Enum_AccountStatuses_All")%></a></span>
                <span class="tn-action <%if(isCreater) Response.Write("tn-selected"); %>">
                    <a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListMyClubs", "ClubUserDomain", new RouteValueDictionary { { "userDomainName", userDomainName },{"isCreater",true
                    } })%>">
                        <%=GetResourceString("Title_MyCreatedClub", applicationID)%></a></span>
            </div>
        </div>
        <ul class="tn-list tn-helper-reset">
            <% if (ViewData.Model != null && ViewData.Model.Records != null && ViewData.Model.Records.Count > 0)
               {
                   foreach (Club club in ViewData.Model.Records)
                   {
                       if (club != null)
                       {%>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-area-left">
                    <div class="tn-avatar">
                        <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank">
                            <%=SPBHtmlHelper.Instance().ShowClubLogo(club.ClubID, ClubLogoSizeTypes.Small, new RouteValueDictionary { { "alt", club.ClubName }})%>
                        </a>
                    </div>
                </div>
                <% if (CurrentUser != null && CurrentUser.UserID == club.ClubOwnerUserID)
                   {%>
                <div class="tn-list-item-area-right">
                    <ul class="tn-list-actions tn-helper-reset">
                        <li class="tn-list-action tn-border-gray tn-border-bottom">
                            <a target="_blank" href="<%=SPBUrlHelper.Action("Home","ClubManage",new RouteValueDictionary{{"clubDomainName",club.DomainName}}) %>">
                                <span>
                                    <%=GetResourceString("Action_Manage")%><%=GetResourceString("Title_Club",applicationID) %></span></a></li>
                    </ul>
                </div>
                <%} %>
                <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                        <h5 class="tn-helper-reset">
                            <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank">
                                <%=club.ClubName %></a></h5>
                    </div>
                    <div class="tn-list-item-row tn-list-item-summary">
                        <p class="tn-helper-reset">
                            <%=HtmlUtils.TrimHtml(club.Brief,150) %></p>
                    </div>
                    <div class="tn-list-item-row">
                        <em class="tn-count tn-text-note">
                            <%=GetResourceString("Label_ClubMemberCount", applicationID)%><%=GetResourceString("Common_Colon") %><%=club.MemberCount %></em>
                        <%if (club.ClubSiteCategoy != null)
                          {%>
                        <cite class="tn-text-note">
                            <%=GetResourceString("Label_BelongCategory",applicationID) %><%=GetResourceString("Common_Colon") %><a
                                href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"categoryID",club.ClubSiteCategoy.CategoryID}}) %>"
                                class="tn-category"><%=club.ClubSiteCategoy.GetMultilingualCategoryName(CurrentUserLanguage)%></a></cite>
                        <%} %>
                        <%if (!string.IsNullOrEmpty(club.AreaCode))
                          {%>
                        <cite class="tn-text-note">
                            <%=GetResourceString("Label_BelongArea",applicationID) %><%=GetResourceString("Common_Colon") %>
                            <a class="tn-location" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",club.AreaCode}}) %>">
                                <%=Formatter.FormatArea(club.AreaCode,true) %></a>
                        </cite>
                        <%} %>
                        <em class="tn-date tn-text-note">
                            <%=GetResourceString("Label_ClubCreateDate", applicationID)%><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDate(club.DateCreated) %></em>
                        <em class="tn-count tn-text-note">
                            <%=GetResourceString("Label_PeopleHit", applicationID)%><%=GetResourceString("Common_Colon") %><%=club.HitTimes %></em>
                        <%--<em class="tn-count tn-text-note">
                            <%=GetResourceString("Label_WeekHitTimes", applicationID)%><%=GetResourceString("Common_Colon") %><%=club.StageHitTimes %></em>
                        <em class="tn-count tn-text-note">
                            <%=GetResourceString("Label_Points", applicationID)%><%=GetResourceString("Common_Colon") %><%=club.Points %></em>--%>
                    </div>
                </div>
            </li>
            <%}
                   }
               } %>
        </ul>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%>
            <div class="tn-page-results tn-text-note">
                <%=string.Format(GetResourceString("Label_Pattern_TotalRecords", applicationID), ViewData.Model.TotalRecords)%></div>
        </div>
    </div>
</div>
