﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    int applicationID = ApplicationIDs.Instance().Club();
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    bool isCreater = ViewData.GetBool("isCreater", true);
    User currentDomainUser = Users.GetUser(userDomainName, false);
    bool isOwner = false;
    if (CurrentUser != null && (CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator))
        isOwner = true;
%>
<% if (isOwner)
   {%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <ul class="spb-nav2 tn-helper-reset tn-helper-left">
            <li class="spb-nav-item tn-text-note tn-selected">
                <a href="<%=SPBUrlHelper.Action("ListMyClubs", "ClubUserDomain", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
                    <span>
                        <%=GetResourceString("Title_MyClub", applicationID)%></span></a></li>
            <li class="spb-nav-item">
                <a href="<%=SiteUrls.Instance().ChannelClubHome() %>" target="_blank">
                    <span>
                        <%=GetResourceString("Title_ElseUserClub", applicationID)%></span></a></li>
        </ul>
        <div class="tn-helper-right">
            <%=SPBHtmlHelper.Instance().LinkButton("newBlogThreadLink", GetResourceString("Button_CreateNewClub", applicationID), SPBUrlHelper.Action("NewClub", "ChannelClub", new RouteValueDictionary { }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Write, TextIconLayout.IconText)%>
        </div>
        <%--<div class="tn-breadcrumb">
                <spb:BreadCrumb ID="BreadCrumb" runat="server" />
            </div>--%>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $("a[menu]").menuButton();
        });
    </script>

</div>
<%} %>