﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    int BlogApplicationID = ApplicationIDs.Instance().Blog();
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000);</script>"));
            TempData["StatusMessageType"] = null;
        }
    }
    
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    ForceLoad="true" SetExpireDays="30">
</spb:Script>
<form id="EditPassWord" class="tn-helper-reset nyroModal" action="<%=ViewData.GetString("actionUrl", string.Empty)%>"
method="post">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%=GetResourceString("Validate_InputPassword")%>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Validate_InputPassword")%><%=GetResourceString("Common_Colon") %></label>
        <input type="text" name="ThreadsPirvacyStatus_Password" id="ThreadsPirvacyStatus_Password"
            value="" class="tn-textbox tn-input-medium tn-border-gray" style="width: 200px"
            maxlength="100" />
    </div>
    <input type="hidden" id="ThreadCheckBoxGroup" name="ThreadCheckBoxGroup"
        value="" />
    <div class="tn-form-row tn-form-row-button tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().SubmitButton("passWordSubmitButtom", GetResourceString("Button_OK"),ButtonSizes.Default,null,null)%>
        <%=SPBHtmlHelper.Instance().Button("cancelButton", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Default, new RouteValueDictionary { { "class", "nyroModalClose" } },null)%>
    </div>
</div>
</form>

<script type="text/javascript">



    $(document).ready(function() {
      var array=new Array(); 
  
    $(":checkbox.thrdadsCheckBoxIDs:checked").each(function(){ 
    if($(this).val())
        array.push($(this).val()); 
    });

   $("#ThreadCheckBoxGroup").val(array.join(','));
    
        $("#EditPassWord").validate({
            rules: {
                ThreadsPirvacyStatus_Password: { required: true, rangelength: [1, 20] }
            },
            messages: {
                ThreadsPirvacyStatus_Password: { required: "<%=GetResourceString("Validate_InputPassword")%>", rangelength: "<%=string.Format(GetResourceString("Validate_PasswordRegexViolated"),20)%>" }
            }
        });
        $("#passWordSubmitButtom").click(function() {
            if (!$("#EditPassWord").valid()) {
                return false;
            }
        });
    }); 
</script>

