﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<UserCategory>" %>
<%UserCategory userCategory = ViewData.Model; %>
<%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName"); %>
<%   
    string multiUserCategoryItemKey = ViewData.GetString("multiUserCategoryItemKey", string.Empty);
    int applicationID = ApplicationIDs.Instance().User();
    if (TempData["statusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.dialog.closeAll();',3000);</script>"));
        }

        TempData["statusMessageData"] = null;
    }
%>

<div class="tn-form tn-label-right">
  <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
    <% if (userCategory.CategoryID > 0) Response.Write(GetResourceString("Title_EditUserFriendCategory", applicationID)); else Response.Write(GetResourceString("Title_AddUserFriendCategory", applicationID)); %>
  </h4>
  <form id="EditGroupForm" class="artDialog" action="<%=SPBUrlHelper.Action("CreateUpdateGroup","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"multiUserCategoryItemKey",multiUserCategoryItemKey},{"categoryID",userCategory.CategoryID}}) %>"
    method="post">
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_UserFriendCategoryName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
      <input type="text" name="groupName" id="groupName" value="<%=userCategory.CategoryName %>"
            class="tn-textbox tn-input-medium tn-border-gray" style="width: 200px" maxlength="100" />
    </div>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
      <textarea id="groupDescription" name="groupDescription" style="width: 241px; height: 124px"
            class="tn-textarea tn-input-long tn-border-gray"><%=userCategory.Description %></textarea>
            <span style="display:none"></span>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_OrderNO")%><%=GetResourceString("Common_Colon") %></label>
      <input type="text" name="groupOrder" id="groupOrder" value="<%=userCategory.DisplayOrder %>"
            class="tn-textbox tn-input-medium tn-border-gray" style="width: 200px" maxlength="100" />
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("Submit", GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%> <%=SPBHtmlHelper.Instance().Button("cancelButton", GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "dialogClose" } }, null)%> </div>
  </form>
</div>
<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#EditGroupForm").validate({
            rules: {
                groupName: { required: true, maxBlength: 20 },
                groupDescription: { maxBlength: 200 },
                groupOrder: { required: true, digits: true }
            },
            messages: {
                groupName: { required: "<%=GetResourceString("Validate_GroupName_Required", applicationID)%>", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_GroupName_Maxlength",applicationID),20)%>" },
                groupDescription: { maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_GroupDescription_Maxlength",applicationID),200)%>" },
                groupOrder: { required: "<%=GetResourceString("Validate_GroupOrder_Required", applicationID)%>", digits: "<%=GetResourceString("Validate_GroupOrder_Digits", applicationID)%>" }
            }
        });
        
        $("#groupSubmitButton").click(function() {
            if (!$("#EditGroupForm").valid()) {
                return false;
            }
        });
    }); 
</script>
