﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<UserCategory>>" %>
<spb:script runat="server" id="artDialog" src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    setexpiredays="30" />
<% 
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();
    string multiUserCategoryItemKey = ViewData.GetString("multiUserCategoryItemKey", string.Empty);
    if (TempData["statusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        if (statusMessageData.MessageType == StatusMessageType.Success)
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, 2000));
        else
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        TempData["statusMessageData"] = null;
    }
%>
<div id="groupForLoad">
    <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_NewGroup", ApplicationIDs.Instance().Friend()), SPBUrlHelper.Action("Control_EditGroup", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName }, { "multiUserCategoryItemKey", multiUserCategoryItemKey } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText, new RouteValueDictionary { { "id", "newGroupModal" } }, null)%>
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_UserFriendCategoryName", applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_OrderNO")%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_ItemCount",applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_CreateDate",applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Actions") %>
            </th>
        </tr>
        <% if (ViewData.Model != null && ViewData.Model.Count > 0)
           {
               foreach (UserCategory userCategory in Model)
               {%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
                <%=userCategory.CategoryName%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <%=userCategory.DisplayOrder%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <%=userCategory.ItemCount%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap">
                <%=Formatter.FormatDate(userCategory.DateCreated)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
                <span class="tn-action"><a class="EditTheGroup tn-action-text" href="<%=SPBUrlHelper.Action("Control_EditGroup","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"multiUserCategoryItemKey",multiUserCategoryItemKey},{"categoryID",userCategory.CategoryID}}) %>">
                    <%=GetResourceString("Action_Edit")%>
                </a></span><span class="tn-action"><a href="<%=SPBUrlHelper.Action("DeleteGroup","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"multiUserCategoryItemKey",multiUserCategoryItemKey},{"categoryID",userCategory.CategoryID}}) %>"
                    class="tn-action-text" onclick="if (!confirm('<%=GetResourceString("Message_UserFirendCategoryDeleteConfirm",applicationID)%>')) { return false;}">
                    <%=GetResourceString("Action_Delete")%>
                </a></span>
            </td>
        </tr>
        <%}
           } %>
    </table>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('a.EditTheGroup,#newGroupModal').dialog({
            closeFn: function () {
                $('#groupForLoad').parent().load('<%=SPBUrlHelper.Action("Control_ManageGroups","UserDomain",new RouteValueDictionary{{"userDomainName",userDomainName},{"multiUserCategoryItemKey",multiUserCategoryItemKey}}) %>');
            }
        });
    });
</script>
